/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.StringValue;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ContractUpdateTransactionBody;
import com.hedera.hashgraph.sdk.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class ContractUpdateTransaction
extends com.hedera.hashgraph.sdk.Transaction<ContractUpdateTransaction> {
    private final ContractUpdateTransactionBody.Builder builder;

    public ContractUpdateTransaction() {
        this.builder = ContractUpdateTransactionBody.newBuilder();
    }

    ContractUpdateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (ContractUpdateTransactionBody.Builder)this.bodyBuilder.getContractUpdateInstance().toBuilder();
    }

    @Nullable
    public ContractId getContractId() {
        return this.builder.hasContractID() ? ContractId.fromProtobuf(this.builder.getContractID()) : null;
    }

    public ContractUpdateTransaction setContractId(ContractId contractId) {
        this.requireNotFrozen();
        this.builder.setContractID(contractId.toProtobuf());
        return this;
    }

    @Nullable
    public Instant getExpirationTime() {
        return this.builder.hasExpirationTime() ? InstantConverter.fromProtobuf(this.builder.getExpirationTime()) : null;
    }

    public ContractUpdateTransaction setExpirationTime(Instant expirationTime) {
        this.requireNotFrozen();
        this.builder.setExpirationTime(InstantConverter.toProtobuf(expirationTime));
        return this;
    }

    @Nullable
    public Key getAdminKey() {
        return this.builder.hasAdminKey() ? Key.fromProtobufKey(this.builder.getAdminKey()) : null;
    }

    public ContractUpdateTransaction setAdminKey(Key adminKey) {
        this.requireNotFrozen();
        this.builder.setAdminKey(adminKey.toProtobufKey());
        return this;
    }

    @Nullable
    public AccountId getProxyAccountId() {
        return this.builder.hasProxyAccountID() ? AccountId.fromProtobuf(this.builder.getProxyAccountID()) : null;
    }

    public ContractUpdateTransaction setProxyAccountId(AccountId proxyAccountId) {
        this.requireNotFrozen();
        this.builder.setProxyAccountID(proxyAccountId.toProtobuf());
        return this;
    }

    @Nullable
    public Duration getAutoRenewPeriod() {
        return this.builder.hasAutoRenewPeriod() ? DurationConverter.fromProtobuf(this.builder.getAutoRenewPeriod()) : null;
    }

    public ContractUpdateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        this.requireNotFrozen();
        this.builder.setAutoRenewPeriod(DurationConverter.toProtobuf(autoRenewPeriod));
        return this;
    }

    @Nullable
    public FileId getBytecodeFileId() {
        return this.builder.hasFileID() ? FileId.fromProtobuf(this.builder.getFileID()) : null;
    }

    public ContractUpdateTransaction setBytecodeFileId(FileId byteCodeFileId) {
        this.requireNotFrozen();
        this.builder.setFileID(byteCodeFileId.toProtobuf());
        return this;
    }

    public String getContractMemo() {
        return this.builder.getMemoWrapper().getValue();
    }

    public ContractUpdateTransaction setContractMemo(String memo) {
        this.requireNotFrozen();
        this.builder.setMemoWrapper(StringValue.of((String)memo));
        return this;
    }

    public ContractUpdateTransaction clearMemo() {
        this.requireNotFrozen();
        this.builder.clearMemoWrapper();
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return SmartContractServiceGrpc.getUpdateContractMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setContractUpdateInstance(this.builder);
        return true;
    }
}

