/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.util.concurrent.ListenableFuture;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Delayer;
import com.hedera.hashgraph.sdk.Node;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.WithExecute;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCalls;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.javacrumbs.futureconverter.common.internal.ValueSource;
import net.javacrumbs.futureconverter.guavacommon.GuavaFutureUtils;
import net.javacrumbs.futureconverter.java8common.Java8FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Executable<SdkRequestT, ProtoRequestT, ResponseT, O>
implements WithExecute<O> {
    private static final Logger logger = LoggerFactory.getLogger(Executable.class);
    protected int maxRetries = 10;
    protected int nextNodeIndex = 0;
    protected List<AccountId> nodeAccountIds = Collections.emptyList();

    Executable() {
    }

    public final int getMaxRetry() {
        return this.maxRetries;
    }

    public final SdkRequestT setMaxRetry(int count) {
        this.maxRetries = count;
        return (SdkRequestT)this;
    }

    @Nullable
    public final List<AccountId> getNodeAccountIds() {
        if (!this.nodeAccountIds.isEmpty()) {
            return this.nodeAccountIds;
        }
        return null;
    }

    public SdkRequestT setNodeAccountIds(List<AccountId> nodeAccountIds) {
        this.nodeAccountIds = nodeAccountIds;
        return (SdkRequestT)this;
    }

    abstract CompletableFuture<Void> onExecuteAsync(Client var1);

    @Override
    public CompletableFuture<O> executeAsync(Client client) {
        return this.onExecuteAsync(client).thenCompose(v -> this.executeAsync(client, 1, null));
    }

    private CompletableFuture<O> executeAsync(Client client, int attempt, @Nullable Throwable lastException) {
        if (attempt > this.maxRetries) {
            return CompletableFuture.failedFuture(new Exception("Failed to get gRPC response within maximum retry count", lastException));
        }
        Node node = client.network.networkNodes.get(this.getNodeAccountId());
        node.inUse();
        logger.trace("sending request \nnode={}\nattempt={}\n{}", new Object[]{node.accountId, attempt, this});
        if (!node.isHealthy()) {
            logger.error("using unhealthy node={}\ndelaying until {}ms\nattempt={}\n", new Object[]{node.accountId, node.delayUntil, attempt});
            return Delayer.delayFor(node.delay(), client.executor).thenCompose(v -> this.executeAsync(client, attempt + 1, lastException));
        }
        MethodDescriptor<ProtoRequestT, ResponseT> methodDescriptor = this.getMethodDescriptor();
        ClientCall call = node.getChannel().newCall(methodDescriptor, CallOptions.DEFAULT);
        ProtoRequestT request = this.makeRequest();
        this.advanceRequest();
        long startAt = System.nanoTime();
        return ((CompletableFuture)Java8FutureUtils.createCompletableFuture((ValueSource)GuavaFutureUtils.createValueSource((ListenableFuture)ClientCalls.futureUnaryCall((ClientCall)call, request))).handle((response, error) -> {
            double latency = (double)(System.nanoTime() - startAt) / 1.0E9;
            long delay = (long)Math.min(250.0 * Math.pow(2.0, attempt - 1), 8000.0);
            if (this.shouldRetryExceptionally((Throwable)error)) {
                logger.error("caught error, retrying\nnode={}\nattempt={}\n{}", new Object[]{node.accountId, attempt, error});
                node.increaseDelay();
                return this.executeAsync(client, attempt + 1, (Throwable)error);
            }
            if (error != null) {
                return CompletableFuture.failedFuture(error);
            }
            node.decreaseDelay();
            Status responseStatus = this.mapResponseStatus(response);
            logger.trace("received response in {}s\nnode={}\nattempt={}\nstatus={}\n{}", new Object[]{latency, node.accountId, attempt, responseStatus, response});
            if (this.shouldRetry(responseStatus, response)) {
                return Delayer.delayFor(delay, client.executor).thenCompose(v -> this.executeAsync(client, attempt + 1, new PrecheckStatusException(responseStatus, this.getTransactionId())));
            }
            if (responseStatus != Status.OK && responseStatus != Status.SUCCESS) {
                return CompletableFuture.failedFuture(new PrecheckStatusException(responseStatus, this.getTransactionId()));
            }
            return CompletableFuture.completedFuture(this.mapResponse(response, node.accountId, request));
        })).thenCompose(x -> x);
    }

    abstract ProtoRequestT makeRequest();

    void advanceRequest() {
        this.nextNodeIndex = (this.nextNodeIndex + 1) % this.nodeAccountIds.size();
    }

    abstract O mapResponse(ResponseT var1, AccountId var2, ProtoRequestT var3);

    abstract Status mapResponseStatus(ResponseT var1);

    abstract MethodDescriptor<ProtoRequestT, ResponseT> getMethodDescriptor();

    final AccountId getNodeAccountId() {
        if (!this.nodeAccountIds.isEmpty()) {
            return this.nodeAccountIds.get(this.nextNodeIndex);
        }
        throw new IllegalStateException("Request node account IDs were not set before executing");
    }

    @Nullable
    abstract TransactionId getTransactionId();

    boolean shouldRetryExceptionally(@Nullable Throwable error) {
        if (error instanceof StatusRuntimeException) {
            Status.Code status = ((StatusRuntimeException)error).getStatus().getCode();
            return status.equals((Object)io.grpc.Status.UNAVAILABLE.getCode()) || status.equals((Object)io.grpc.Status.RESOURCE_EXHAUSTED.getCode());
        }
        return false;
    }

    boolean shouldRetry(Status status, ResponseT response) {
        if (status == Status.PLATFORM_TRANSACTION_NOT_CREATED) {
            return true;
        }
        return status == Status.BUSY;
    }
}

