/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.FileCreateTransactionBody;
import com.hedera.hashgraph.sdk.proto.FileServiceGrpc;
import com.hedera.hashgraph.sdk.proto.KeyList;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class FileCreateTransaction
extends com.hedera.hashgraph.sdk.Transaction<FileCreateTransaction> {
    private final FileCreateTransactionBody.Builder builder;

    public FileCreateTransaction() {
        this.builder = FileCreateTransactionBody.newBuilder();
        this.setExpirationTime(Instant.now().plus(DEFAULT_AUTO_RENEW_PERIOD));
        this.setMaxTransactionFee(new Hbar(5L));
    }

    FileCreateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (FileCreateTransactionBody.Builder)this.bodyBuilder.getFileCreate().toBuilder();
    }

    @Nullable
    public Instant getExpirationTime() {
        return this.builder.hasExpirationTime() ? InstantConverter.fromProtobuf(this.builder.getExpirationTime()) : null;
    }

    public FileCreateTransaction setExpirationTime(Instant expirationTime) {
        this.requireNotFrozen();
        this.builder.setExpirationTime(InstantConverter.toProtobuf(expirationTime));
        return this;
    }

    public Collection<Key> getKeys() {
        return com.hedera.hashgraph.sdk.KeyList.fromProtobuf(this.builder.getKeys(), null);
    }

    public FileCreateTransaction setKeys(Key ... keys) {
        this.requireNotFrozen();
        KeyList.Builder keyList = KeyList.newBuilder();
        for (Key key : keys) {
            keyList.addKeys(key.toProtobufKey());
        }
        this.builder.setKeys(keyList);
        return this;
    }

    public ByteString getContents() {
        return this.builder.getContents();
    }

    public FileCreateTransaction setContents(byte[] bytes) {
        this.requireNotFrozen();
        this.builder.setContents(ByteString.copyFrom((byte[])bytes));
        return this;
    }

    public FileCreateTransaction setContents(String text) {
        this.requireNotFrozen();
        this.builder.setContents(ByteString.copyFromUtf8((String)text));
        return this;
    }

    public String getFileMemo() {
        return this.builder.getMemo();
    }

    public FileCreateTransaction setFileMemo(String memo) {
        this.requireNotFrozen();
        this.builder.setMemo(memo);
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return FileServiceGrpc.getCreateFileMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setFileCreate(this.builder);
        return true;
    }
}

