/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.EntityIdHelper;
import com.hedera.hashgraph.sdk.proto.FileID;
import java.util.Objects;
import javax.annotation.Nonnegative;

public final class FileId {
    @Nonnegative
    public final long shard;
    @Nonnegative
    public final long realm;
    @Nonnegative
    public final long num;
    public static final FileId ADDRESS_BOOK = new FileId(0L, 0L, 102L);
    public static final FileId FEE_SCHEDULE = new FileId(0L, 0L, 111L);
    public static final FileId EXCHANGE_RATES = new FileId(0L, 0L, 112L);

    public FileId(@Nonnegative long num) {
        this(0L, 0L, num);
    }

    public FileId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
    }

    public static FileId fromString(String id) {
        return EntityIdHelper.fromString(id, FileId::new);
    }

    public static FileId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return FileId.fromProtobuf((FileID)((FileID.Builder)FileID.parseFrom(bytes).toBuilder()).build());
    }

    static FileId fromProtobuf(FileID fileId) {
        return new FileId(fileId.getShardNum(), fileId.getRealmNum(), fileId.getFileNum());
    }

    FileID toProtobuf() {
        return (FileID)FileID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setFileNum(this.num).build();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        return this.shard + "." + this.realm + "." + this.num;
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.num);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileId)) {
            return false;
        }
        FileId otherId = (FileId)o;
        return this.shard == otherId.shard && this.realm == otherId.realm && this.num == otherId.num;
    }
}

