/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.StringValue;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.FileServiceGrpc;
import com.hedera.hashgraph.sdk.proto.FileUpdateTransactionBody;
import com.hedera.hashgraph.sdk.proto.KeyList;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class FileUpdateTransaction
extends com.hedera.hashgraph.sdk.Transaction<FileUpdateTransaction> {
    private final FileUpdateTransactionBody.Builder builder;

    public FileUpdateTransaction() {
        this.builder = FileUpdateTransactionBody.newBuilder();
    }

    FileUpdateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (FileUpdateTransactionBody.Builder)this.bodyBuilder.getFileUpdate().toBuilder();
    }

    @Nullable
    public FileId getFileId() {
        return this.builder.hasFileID() ? FileId.fromProtobuf(this.builder.getFileID()) : null;
    }

    public FileUpdateTransaction setFileId(FileId fileId) {
        this.requireNotFrozen();
        this.builder.setFileID(fileId.toProtobuf());
        return this;
    }

    public Collection<Key> getKeys() {
        return com.hedera.hashgraph.sdk.KeyList.fromProtobuf(this.builder.getKeys(), null);
    }

    public FileUpdateTransaction setKeys(Key ... keys) {
        this.requireNotFrozen();
        KeyList.Builder keyList = KeyList.newBuilder();
        for (Key key : keys) {
            keyList.addKeys(key.toProtobufKey());
        }
        this.builder.setKeys(keyList);
        return this;
    }

    @Nullable
    public Instant getExpirationTime() {
        return this.builder.hasExpirationTime() ? InstantConverter.fromProtobuf(this.builder.getExpirationTime()) : null;
    }

    public FileUpdateTransaction setExpirationTime(Instant expirationTime) {
        this.requireNotFrozen();
        this.builder.setExpirationTime(InstantConverter.toProtobuf(expirationTime));
        return this;
    }

    public ByteString getContents() {
        return this.builder.getContents();
    }

    public FileUpdateTransaction setContents(byte[] bytes) {
        this.requireNotFrozen();
        this.builder.setContents(ByteString.copyFrom((byte[])bytes));
        return this;
    }

    public FileUpdateTransaction setContents(String text) {
        this.requireNotFrozen();
        this.builder.setContents(ByteString.copyFromUtf8((String)text));
        return this;
    }

    public String getFileMemo() {
        return this.builder.getMemo().getValue();
    }

    public FileUpdateTransaction setFileMemo(String memo) {
        this.requireNotFrozen();
        this.builder.setMemo(StringValue.of((String)memo));
        return this;
    }

    public FileUpdateTransaction clearMemo() {
        this.requireNotFrozen();
        this.builder.clearMemo();
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return FileServiceGrpc.getUpdateFileMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setFileUpdate(this.builder);
        return true;
    }
}

