/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.FreezeServiceGrpc;
import com.hedera.hashgraph.sdk.proto.FreezeTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Instant;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.LinkedHashMap;

public final class FreezeTransaction
extends com.hedera.hashgraph.sdk.Transaction<FreezeTransaction> {
    private final FreezeTransactionBody.Builder builder;

    public FreezeTransaction() {
        this.builder = FreezeTransactionBody.newBuilder();
    }

    FreezeTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (FreezeTransactionBody.Builder)this.bodyBuilder.getFreeze().toBuilder();
    }

    public Instant getStartTime() {
        return Instant.from(OffsetTime.of(this.builder.getStartHour(), this.builder.getStartMin(), 0, 0, ZoneOffset.UTC));
    }

    public FreezeTransaction setStartTime(int hour, int minute) {
        this.requireNotFrozen();
        this.builder.setStartHour(hour);
        this.builder.setStartMin(minute);
        return this;
    }

    public Instant getEndTime() {
        return Instant.from(OffsetTime.of(this.builder.getEndHour(), this.builder.getEndMin(), 0, 0, ZoneOffset.UTC));
    }

    public FreezeTransaction setEndTime(int hour, int minute) {
        this.requireNotFrozen();
        this.builder.setEndHour(hour);
        this.builder.setEndMin(minute);
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return FreezeServiceGrpc.getFreezeMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setFreeze(this.builder);
        return true;
    }
}

