/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.CryptoAddLiveHashTransactionBody;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.KeyList;
import com.hedera.hashgraph.sdk.proto.LiveHash;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class LiveHashAddTransaction
extends com.hedera.hashgraph.sdk.Transaction<LiveHashAddTransaction> {
    private final CryptoAddLiveHashTransactionBody.Builder builder;
    private final LiveHash.Builder hashBuilder;

    public LiveHashAddTransaction() {
        this.builder = CryptoAddLiveHashTransactionBody.newBuilder();
        this.hashBuilder = LiveHash.newBuilder();
    }

    LiveHashAddTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (CryptoAddLiveHashTransactionBody.Builder)this.bodyBuilder.getCryptoAddLiveHash().toBuilder();
        this.hashBuilder = (LiveHash.Builder)this.builder.getLiveHash().toBuilder();
    }

    @Nullable
    public AccountId getAccountId() {
        return this.hashBuilder.hasAccountId() ? AccountId.fromProtobuf(this.hashBuilder.getAccountId()) : null;
    }

    public LiveHashAddTransaction setAccountId(AccountId accountId) {
        this.requireNotFrozen();
        this.hashBuilder.setAccountId(accountId.toProtobuf());
        return this;
    }

    public ByteString getHash() {
        return this.hashBuilder.getHash();
    }

    public LiveHashAddTransaction setHash(byte[] hash) {
        return this.setHash(ByteString.copyFrom((byte[])hash));
    }

    public LiveHashAddTransaction setHash(ByteString hash) {
        this.requireNotFrozen();
        this.hashBuilder.setHash(hash);
        return this;
    }

    public Collection<Key> getKeys() {
        return com.hedera.hashgraph.sdk.KeyList.fromProtobuf(this.hashBuilder.getKeys(), null);
    }

    public LiveHashAddTransaction setKeys(Key ... keys) {
        this.requireNotFrozen();
        KeyList.Builder keyList = KeyList.newBuilder();
        for (Key key : keys) {
            keyList.addKeys(key.toProtobufKey());
        }
        this.hashBuilder.setKeys(keyList);
        return this;
    }

    @Nullable
    public Duration getDuration() {
        return this.hashBuilder.hasDuration() ? DurationConverter.fromProtobuf(this.hashBuilder.getDuration()) : null;
    }

    public LiveHashAddTransaction setDuration(Duration duration) {
        this.requireNotFrozen();
        this.hashBuilder.setDuration(DurationConverter.toProtobuf(duration));
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getAddLiveHashMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setCryptoAddLiveHash(this.builder.setLiveHash(this.hashBuilder));
        return true;
    }
}

