/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.MirrorNode;
import com.hedera.hashgraph.sdk.ThreadLocalSecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

class MirrorNetwork {
    List<String> addresses = new ArrayList<String>();
    List<MirrorNode> network = new ArrayList<MirrorNode>();
    int index = 0;
    final ExecutorService executor;

    MirrorNetwork(ExecutorService executor) {
        this.executor = executor;
        try {
            this.setNetwork(this.addresses);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void setNetwork(List<String> addresses) throws InterruptedException {
        long stopAt = Instant.now().getEpochSecond() + Duration.ofSeconds(30L).getSeconds();
        for (int i = 0; i < this.network.size(); ++i) {
            if (addresses.contains(this.network.get((int)i).address)) continue;
            this.network.get(i).close(stopAt - Instant.now().getEpochSecond());
            this.network.remove(i);
            --i;
        }
        for (String address : addresses) {
            boolean contains = false;
            for (MirrorNode node : this.network) {
                if (!node.address.equals(address)) continue;
                contains = true;
            }
            if (contains) continue;
            this.network.add(new MirrorNode(address, this.executor));
        }
        this.addresses = new ArrayList<String>(addresses);
        Collections.shuffle(this.network, ThreadLocalSecureRandom.current());
    }

    MirrorNode getNextMirrorNode() {
        MirrorNode node = this.network.get(this.index);
        this.index = (this.index + 1) % this.network.size();
        return node;
    }

    void close(Duration timeout) {
        for (MirrorNode node : this.network) {
            if (node.channel == null) continue;
            node.channel.shutdown();
        }
        for (MirrorNode node : this.network) {
            if (node.channel == null) continue;
            try {
                while (!node.channel.awaitTermination(timeout.getSeconds(), TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.network.clear();
        this.addresses.clear();
        this.index = 0;
    }
}

