/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Node;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class Network {
    Map<String, AccountId> network = new HashMap<String, AccountId>();
    Map<AccountId, Node> networkNodes = new HashMap<AccountId, Node>();
    List<Node> nodes = new ArrayList<Node>();
    final ExecutorService executor;

    Network(ExecutorService executor, Map<String, AccountId> network) {
        this.executor = executor;
        try {
            this.setNetwork(network);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    void setNetwork(Map<String, AccountId> network) throws InterruptedException, TimeoutException {
        if (this.network.isEmpty()) {
            this.network = new HashMap<String, AccountId>(network);
            for (Map.Entry<String, AccountId> entry : network.entrySet()) {
                Node node = new Node(entry.getValue(), entry.getKey(), this.executor);
                this.networkNodes.put(entry.getValue(), node);
                this.nodes.add(node);
            }
            return;
        }
        this.network = new HashMap<String, AccountId>(network);
        BiMap inverted = HashBiMap.create(network).inverse();
        Collection<AccountId> newNodeAccountIds = network.values();
        long stopAt = Instant.now().getEpochSecond() + Duration.ofSeconds(30L).getSeconds();
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (stopAt - Instant.now().getEpochSecond() == 0L) {
                throw new TimeoutException("Failed to properly shutdown all channels");
            }
            if (newNodeAccountIds.contains(this.nodes.get((int)i).accountId) && ((String)inverted.get((Object)this.nodes.get((int)i).accountId)).equals(this.nodes.get((int)i).address)) continue;
            this.networkNodes.remove(this.nodes.get((int)i).accountId);
            this.nodes.get(i).close(stopAt - Instant.now().toEpochMilli());
            this.nodes.remove(i);
            --i;
        }
        for (Map.Entry entry : inverted.entrySet()) {
            if (this.networkNodes.get(entry.getKey()) != null) continue;
            Node node = new Node((AccountId)entry.getKey(), (String)entry.getValue(), this.executor);
            this.nodes.add(node);
            this.networkNodes.put((AccountId)entry.getKey(), node);
        }
    }

    List<AccountId> getNodeAccountIdsForExecute() {
        Collections.sort(this.nodes);
        ArrayList<AccountId> resultNodeAccountIds = new ArrayList<AccountId>();
        for (int i = 0; i < this.getNumberOfNodesForTransaction(); ++i) {
            resultNodeAccountIds.add(this.nodes.get((int)i).accountId);
        }
        return resultNodeAccountIds;
    }

    int getNumberOfNodesForTransaction() {
        int count = 0;
        for (Node node : this.nodes) {
            count += node.isHealthy() ? 1 : 1;
        }
        return (count + 3 - 1) / 3;
    }

    void close(Duration timeout) throws TimeoutException {
        long stopAt = Instant.now().getEpochSecond() + timeout.getSeconds();
        for (Node node : this.nodes) {
            if (node.channel == null) continue;
            node.channel = node.channel.shutdown();
        }
        for (Node node : this.nodes) {
            if (stopAt - Instant.now().getEpochSecond() == 0L) {
                throw new TimeoutException("Failed to properly shutdown all channels");
            }
            if (node.channel == null) continue;
            try {
                node.channel.awaitTermination(stopAt - Instant.now().getEpochSecond(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.nodes.clear();
        this.networkNodes.clear();
        this.network.clear();
    }
}

