/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.BadKeyException;
import com.hedera.hashgraph.sdk.Mnemonic;
import com.hedera.hashgraph.sdk.Pem;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.ThreadLocalSecureRandom;
import com.hedera.hashgraph.sdk.Transaction;
import com.hedera.hashgraph.sdk.proto.Key;
import com.hedera.hashgraph.sdk.proto.SignedTransaction;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import org.bouncycastle.util.encoders.Hex;

public final class PrivateKey
extends com.hedera.hashgraph.sdk.Key {
    private final byte[] keyData;
    @Nullable
    private final KeyParameter chainCode;
    @Nullable
    private PublicKey publicKey;

    PrivateKey(byte[] keyData, @Nullable KeyParameter chainCode) {
        this.keyData = keyData;
        this.chainCode = chainCode;
    }

    public static PrivateKey generate() {
        byte[] data = new byte[64];
        ThreadLocalSecureRandom.current().nextBytes(data);
        return PrivateKey.derivableKey(data);
    }

    public static PrivateKey fromMnemonic(Mnemonic mnemonic, String passphrase) {
        byte[] seed = mnemonic.toSeed(passphrase);
        HMac hmacSha512 = new HMac((Digest)new SHA512Digest());
        hmacSha512.init((CipherParameters)new KeyParameter("ed25519 seed".getBytes(StandardCharsets.UTF_8)));
        hmacSha512.update(seed, 0, seed.length);
        byte[] derivedState = new byte[hmacSha512.getMacSize()];
        hmacSha512.doFinal(derivedState, 0);
        PrivateKey derivedKey = PrivateKey.derivableKey(derivedState);
        for (int index : new int[]{44, 3030, 0, 0}) {
            derivedKey = derivedKey.derive(index);
        }
        return derivedKey;
    }

    public static PrivateKey fromMnemonic(Mnemonic mnemonic) {
        return PrivateKey.fromMnemonic(mnemonic, "");
    }

    public static PrivateKey fromString(String privateKey) {
        return PrivateKey.fromBytes(Hex.decode((String)privateKey));
    }

    public static PrivateKey fromBytes(byte[] privateKey) {
        if (privateKey.length == 32 || privateKey.length == 64) {
            return new PrivateKey(Arrays.copyOfRange(privateKey, 0, 32), null);
        }
        return PrivateKey.fromPrivateKeyInfo(PrivateKeyInfo.getInstance((Object)privateKey));
    }

    private static PrivateKey fromPrivateKeyInfo(PrivateKeyInfo privateKeyInfo) {
        try {
            ASN1OctetString privateKey = (ASN1OctetString)privateKeyInfo.parsePrivateKey();
            return new PrivateKey(privateKey.getOctets(), null);
        }
        catch (IOException e) {
            throw new BadKeyException(e);
        }
    }

    private static PrivateKey derivableKey(byte[] deriveData) {
        byte[] keyData = Arrays.copyOfRange(deriveData, 0, 32);
        KeyParameter chainCode = new KeyParameter(deriveData, 32, 32);
        return new PrivateKey(keyData, chainCode);
    }

    public PrivateKey legacyDerive(int index) {
        byte[] keyBytes = PrivateKey.legacyDeriveChildKey(this.keyData, index);
        return PrivateKey.fromBytes(keyBytes);
    }

    public static PrivateKey readPem(Reader pemFile) throws IOException {
        return PrivateKey.readPem(pemFile, null);
    }

    public static PrivateKey readPem(Reader pemFile, @Nullable String password) throws IOException {
        return PrivateKey.fromPrivateKeyInfo(Pem.readPrivateKey(pemFile, password));
    }

    public static PrivateKey fromPem(String pemEncoded) throws IOException {
        return PrivateKey.readPem(new StringReader(pemEncoded));
    }

    public static PrivateKey fromPem(String encodedPem, @Nullable String password) throws IOException {
        return PrivateKey.readPem(new StringReader(encodedPem), password);
    }

    public boolean isDerivable() {
        return this.chainCode != null;
    }

    public PrivateKey derive(int index) {
        if (this.chainCode == null) {
            throw new IllegalStateException("this private key does not support derivation");
        }
        HMac hmacSha512 = new HMac((Digest)new SHA512Digest());
        hmacSha512.init((CipherParameters)this.chainCode);
        hmacSha512.update((byte)0);
        hmacSha512.update(this.keyData, 0, 32);
        byte[] indexBytes = new byte[4];
        ByteBuffer.wrap(indexBytes).order(ByteOrder.BIG_ENDIAN).putInt(index);
        indexBytes[0] = (byte)(indexBytes[0] | 0xFFFFFF80);
        hmacSha512.update(indexBytes, 0, indexBytes.length);
        byte[] output = new byte[64];
        hmacSha512.doFinal(output, 0);
        return PrivateKey.derivableKey(output);
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        byte[] publicKeyData = new byte[32];
        Ed25519.generatePublicKey((byte[])this.keyData, (int)0, (byte[])publicKeyData, (int)0);
        this.publicKey = new PublicKey(publicKeyData);
        return this.publicKey;
    }

    public byte[] sign(byte[] message) {
        byte[] signature = new byte[64];
        Ed25519.sign((byte[])this.keyData, (int)0, (byte[])message, (int)0, (int)message.length, (byte[])signature, (int)0);
        return signature;
    }

    public byte[] signTransaction(Transaction<?> transaction) {
        transaction.requireOneNodeAccountId();
        if (!transaction.isFrozen()) {
            transaction.freeze();
        }
        SignedTransaction.Builder builder = transaction.signedTransactions.get(0);
        byte[] signature = this.sign(builder.getBodyBytes().toByteArray());
        transaction.addSignature(this.getPublicKey(), signature);
        return signature;
    }

    @Override
    public byte[] toBytes() {
        return this.keyData;
    }

    private byte[] toDER() {
        try {
            return new PrivateKeyInfo(new AlgorithmIdentifier(ID_ED25519), (ASN1Encodable)new DEROctetString(this.keyData)).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return Hex.toHexString((byte[])this.toDER());
    }

    @Override
    Key toProtobufKey() {
        return this.getPublicKey().toProtobufKey();
    }

    static byte[] legacyDeriveChildKey(byte[] entropy, int index) {
        byte[] seed = new byte[entropy.length + 8];
        if (index >= 0) {
            Arrays.fill(seed, entropy.length, entropy.length + 4, (byte)0);
        } else {
            Arrays.fill(seed, entropy.length, entropy.length + 4, (byte)-1);
        }
        Arrays.fill(seed, entropy.length + 4, entropy.length + 8, (byte)index);
        System.arraycopy(entropy, 0, seed, 0, entropy.length);
        byte[] salt = new byte[]{-1};
        PKCS5S2ParametersGenerator pbkdf2 = new PKCS5S2ParametersGenerator((Digest)new SHA512Digest());
        pbkdf2.init(seed, salt, 2048);
        KeyParameter key = (KeyParameter)pbkdf2.generateDerivedParameters(256);
        return key.getKey();
    }
}

