/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.Transaction;
import com.hedera.hashgraph.sdk.proto.SignaturePair;
import com.hedera.hashgraph.sdk.proto.SignedTransaction;
import java.io.IOException;
import java.util.Arrays;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import org.bouncycastle.util.encoders.Hex;

public final class PublicKey
extends Key {
    private final byte[] keyData;

    PublicKey(byte[] keyData) {
        this.keyData = keyData;
    }

    public static PublicKey fromBytes(byte[] publicKey) {
        if (publicKey.length == 32) {
            return new PublicKey(publicKey);
        }
        return PublicKey.fromSubjectKeyInfo(SubjectPublicKeyInfo.getInstance((Object)publicKey));
    }

    public static PublicKey fromString(String publicKey) {
        return PublicKey.fromBytes(Hex.decode((String)publicKey));
    }

    private static PublicKey fromSubjectKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return new PublicKey(subjectPublicKeyInfo.getPublicKeyData().getBytes());
    }

    public boolean verify(byte[] message, byte[] signature) {
        return Ed25519.verify((byte[])signature, (int)0, (byte[])this.keyData, (int)0, (byte[])message, (int)0, (int)message.length);
    }

    public boolean verifyTransaction(Transaction<?> transaction) {
        if (!transaction.isFrozen()) {
            transaction.freeze();
        }
        for (SignedTransaction.Builder signedTransaction : transaction.signedTransactions) {
            boolean found = false;
            for (SignaturePair sigPair : signedTransaction.getSigMap().getSigPairList()) {
                if (!sigPair.getPubKeyPrefix().equals((Object)ByteString.copyFrom((byte[])this.toBytes()))) continue;
                found = true;
                if (this.verify(signedTransaction.getBodyBytes().toByteArray(), sigPair.getEd25519().toByteArray())) continue;
                return false;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    com.hedera.hashgraph.sdk.proto.Key toProtobufKey() {
        return (com.hedera.hashgraph.sdk.proto.Key)com.hedera.hashgraph.sdk.proto.Key.newBuilder().setEd25519(ByteString.copyFrom((byte[])this.keyData)).build();
    }

    SignaturePair toSignaturePairProtobuf(byte[] signature) {
        return (SignaturePair)SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFrom((byte[])this.keyData)).setEd25519(ByteString.copyFrom((byte[])signature)).build();
    }

    @Override
    public byte[] toBytes() {
        return this.keyData;
    }

    private byte[] toDER() {
        try {
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(ID_ED25519), this.keyData).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return Hex.toHexString((byte[])this.toDER());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKey publicKey = (PublicKey)o;
        return Arrays.equals(this.keyData, publicKey.keyData);
    }

    public int hashCode() {
        return Arrays.hashCode(this.keyData);
    }
}

