/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Executable;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.MaxQueryPaymentExceededException;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransferTransaction;
import com.hedera.hashgraph.sdk.WithGetCost;
import com.hedera.hashgraph.sdk.proto.Query;
import com.hedera.hashgraph.sdk.proto.QueryHeader;
import com.hedera.hashgraph.sdk.proto.Response;
import com.hedera.hashgraph.sdk.proto.ResponseCodeEnum;
import com.hedera.hashgraph.sdk.proto.ResponseHeader;
import com.hedera.hashgraph.sdk.proto.ResponseType;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import io.grpc.MethodDescriptor;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public abstract class Query<O, T extends Query<O, T>>
extends Executable<T, com.hedera.hashgraph.sdk.proto.Query, Response, O>
implements WithGetCost {
    private final Query.Builder builder = com.hedera.hashgraph.sdk.proto.Query.newBuilder();
    private final QueryHeader.Builder headerBuilder = QueryHeader.newBuilder();
    @Nullable
    private TransactionId paymentTransactionId;
    @Nullable
    private List<Transaction> paymentTransactions;
    @Nullable
    private Hbar queryPayment;
    @Nullable
    private Hbar maxQueryPayment;

    Query() {
    }

    public T setQueryPayment(Hbar queryPayment) {
        this.queryPayment = queryPayment;
        return (T)this;
    }

    public T setMaxQueryPayment(Hbar maxQueryPayment) {
        this.maxQueryPayment = maxQueryPayment;
        return (T)this;
    }

    @Override
    public CompletableFuture<Hbar> getCostAsync(Client client) {
        return this.getCostExecutable().executeAsync(client);
    }

    boolean isPaymentRequired() {
        return true;
    }

    abstract void onMakeRequest(Query.Builder var1, QueryHeader var2);

    abstract ResponseHeader mapResponseHeader(Response var1);

    abstract QueryHeader mapRequestHeader(com.hedera.hashgraph.sdk.proto.Query var1);

    private Query<Hbar, QueryCostQuery> getCostExecutable() {
        return new QueryCostQuery();
    }

    @Override
    CompletableFuture<Void> onExecuteAsync(Client client) {
        if (this.nodeAccountIds.size() == 0) {
            this.nodeAccountIds = client.network.getNodeAccountIdsForExecute();
        }
        if (this.paymentTransactions != null || !this.isPaymentRequired()) {
            return CompletableFuture.completedFuture(null);
        }
        Client.Operator operator = client.getOperator();
        if (operator == null) {
            throw new IllegalStateException("`client` must have an `operator` or an explicit payment transaction must be provided");
        }
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            if (this.queryPayment == null) {
                return this.getCostAsync(client).thenCompose(cost -> {
                    Hbar maxCost = (Hbar)MoreObjects.firstNonNull((Object)this.maxQueryPayment, (Object)client.maxQueryPayment);
                    if (cost.compareTo(maxCost) > 0) {
                        return CompletableFuture.failedFuture(new MaxQueryPaymentExceededException(this, (Hbar)cost, maxCost));
                    }
                    return CompletableFuture.completedFuture(cost);
                });
            }
            return CompletableFuture.completedFuture(this.queryPayment);
        }, client.executor).thenCompose(x -> x)).thenAccept(paymentAmount -> {
            this.paymentTransactionId = TransactionId.generate(operator.accountId);
            this.paymentTransactions = new ArrayList<Transaction>(this.nodeAccountIds.size());
            for (AccountId nodeId : this.nodeAccountIds) {
                this.paymentTransactions.add(Query.makePaymentTransaction(this.paymentTransactionId, nodeId, operator, paymentAmount));
            }
        });
    }

    private static Transaction makePaymentTransaction(TransactionId paymentTransactionId, AccountId nodeId, Client.Operator operator, Hbar paymentAmount) {
        return ((TransferTransaction)((TransferTransaction)((TransferTransaction)((TransferTransaction)((TransferTransaction)new TransferTransaction().setTransactionId(paymentTransactionId)).setNodeAccountIds((List)Collections.singletonList(nodeId))).setMaxTransactionFee(new Hbar(1L))).addHbarTransfer(operator.accountId, paymentAmount.negated()).addHbarTransfer(nodeId, paymentAmount).freeze()).signWith(operator.publicKey, operator.transactionSigner)).makeRequest();
    }

    @Override
    final com.hedera.hashgraph.sdk.proto.Query makeRequest() {
        if (this.isPaymentRequired() && this.paymentTransactions != null) {
            this.headerBuilder.setPayment(this.paymentTransactions.get(this.nextNodeIndex));
        }
        this.onMakeRequest(this.builder, (QueryHeader)this.headerBuilder.setResponseType(ResponseType.ANSWER_ONLY).build());
        return (com.hedera.hashgraph.sdk.proto.Query)this.builder.build();
    }

    @Override
    Status mapResponseStatus(Response response) {
        ResponseCodeEnum preCheckCode = this.mapResponseHeader(response).getNodeTransactionPrecheckCode();
        return Status.valueOf(preCheckCode);
    }

    @Override
    @Nullable
    TransactionId getTransactionId() {
        return this.paymentTransactionId;
    }

    public String toString() {
        com.hedera.hashgraph.sdk.proto.Query request = this.makeRequest();
        StringBuilder builder = new StringBuilder(request.toString().replaceAll("(?m)^# com.hedera.hashgraph.sdk.proto.Query.*", ""));
        QueryHeader queryHeader = this.mapRequestHeader(request);
        if (queryHeader.hasPayment()) {
            builder.append("\n");
            try {
                builder.append(TransactionBody.parseFrom(queryHeader.getPayment().getBodyBytes()).toString().replaceAll("(?m)^# com.hedera.hashgraph.sdk.proto.TransactionBuilder.*", ""));
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
        return builder.toString();
    }

    private class QueryCostQuery
    extends Query<Hbar, QueryCostQuery> {
        private QueryCostQuery() {
        }

        @Override
        void onMakeRequest(Query.Builder queryBuilder, QueryHeader header) {
            Query.this.headerBuilder.setResponseType(ResponseType.COST_ANSWER);
            Query.this.headerBuilder.setPayment(((TransferTransaction)((TransferTransaction)((TransferTransaction)new TransferTransaction().setNodeAccountIds((List)Collections.singletonList(new AccountId(0L)))).setTransactionId(TransactionId.withValidStart(new AccountId(0L), Instant.ofEpochSecond(0L)))).freeze()).makeRequest());
            Query.this.onMakeRequest(queryBuilder, (QueryHeader)Query.this.headerBuilder.build());
        }

        @Override
        ResponseHeader mapResponseHeader(Response response) {
            return Query.this.mapResponseHeader(response);
        }

        @Override
        QueryHeader mapRequestHeader(com.hedera.hashgraph.sdk.proto.Query request) {
            return Query.this.mapRequestHeader(request);
        }

        @Override
        Hbar mapResponse(Response response, AccountId nodeId, com.hedera.hashgraph.sdk.proto.Query Response2) {
            return Hbar.fromTinybars(this.mapResponseHeader(response).getCost());
        }

        @Override
        MethodDescriptor<com.hedera.hashgraph.sdk.proto.Query, Response> getMethodDescriptor() {
            return Query.this.getMethodDescriptor();
        }

        @Override
        boolean isPaymentRequired() {
            return false;
        }
    }
}

