/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.ScheduleId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ScheduleServiceGrpc;
import com.hedera.hashgraph.sdk.proto.ScheduleSignTransactionBody;
import com.hedera.hashgraph.sdk.proto.SignatureMap;
import com.hedera.hashgraph.sdk.proto.SignaturePair;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ScheduleSignTransaction
extends com.hedera.hashgraph.sdk.Transaction<ScheduleSignTransaction> {
    private final ScheduleSignTransactionBody.Builder builder;
    private final SignatureMap.Builder signatureBuilder;

    public ScheduleSignTransaction() {
        this.builder = ScheduleSignTransactionBody.newBuilder();
        this.signatureBuilder = (SignatureMap.Builder)this.builder.getSigMap().toBuilder();
        this.setMaxTransactionFee(new Hbar(5L));
    }

    ScheduleSignTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (ScheduleSignTransactionBody.Builder)this.bodyBuilder.getScheduleSign().toBuilder();
        this.signatureBuilder = (SignatureMap.Builder)this.builder.getSigMap().toBuilder();
    }

    public ScheduleId getScheduleId() {
        return ScheduleId.fromProtobuf(this.builder.getScheduleID());
    }

    public ScheduleSignTransaction setScheduleId(ScheduleId id) {
        this.requireNotFrozen();
        this.builder.setScheduleID(id.toProtobuf());
        return this;
    }

    public ScheduleSignTransaction clearScheduleId() {
        this.requireNotFrozen();
        this.builder.clearScheduleID();
        return this;
    }

    public Map<PublicKey, byte[]> getScheduleSignatures() {
        HashMap<PublicKey, byte[]> map = new HashMap<PublicKey, byte[]>();
        for (SignaturePair sigPair : this.signatureBuilder.getSigPairList()) {
            map.put(PublicKey.fromBytes(sigPair.getPubKeyPrefix().toByteArray()), sigPair.getEd25519().toByteArray());
        }
        return map;
    }

    public ScheduleSignTransaction addScheduleSignature(PublicKey publicKey, byte[] signature) {
        this.signatureBuilder.addSigPair(publicKey.toSignaturePairProtobuf(signature));
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return ScheduleServiceGrpc.getSignScheduleMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setScheduleSign(this.builder.setSigMap(this.signatureBuilder));
        return true;
    }
}

