/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.FileServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SystemDeleteTransactionBody;
import com.hedera.hashgraph.sdk.proto.TimestampSeconds;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Instant;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class SystemDeleteTransaction
extends com.hedera.hashgraph.sdk.Transaction<SystemDeleteTransaction> {
    private final SystemDeleteTransactionBody.Builder builder;

    public SystemDeleteTransaction() {
        this.builder = SystemDeleteTransactionBody.newBuilder();
    }

    SystemDeleteTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (SystemDeleteTransactionBody.Builder)this.bodyBuilder.getSystemDelete().toBuilder();
    }

    @Nullable
    public final FileId getFileId() {
        return this.builder.hasFileID() ? FileId.fromProtobuf(this.builder.getFileID()) : null;
    }

    public SystemDeleteTransaction setFileId(FileId fileId) {
        this.requireNotFrozen();
        this.builder.setFileID(fileId.toProtobuf());
        return this;
    }

    @Nullable
    public final ContractId getContractId() {
        return this.builder.hasContractID() ? ContractId.fromProtobuf(this.builder.getContractID()) : null;
    }

    public SystemDeleteTransaction setContractId(ContractId contractId) {
        this.requireNotFrozen();
        this.builder.setContractID(contractId.toProtobuf());
        return this;
    }

    @Nullable
    public final Instant getExpirationTime() {
        return this.builder.hasExpirationTime() ? InstantConverter.fromProtobuf(this.builder.getExpirationTime()) : null;
    }

    public SystemDeleteTransaction setExpirationTime(Instant expirationTime) {
        this.requireNotFrozen();
        this.builder.setExpirationTime((TimestampSeconds)TimestampSeconds.newBuilder().setSeconds(expirationTime.getEpochSecond()).build());
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        switch (this.builder.getIdCase()) {
            case FILEID: {
                return FileServiceGrpc.getSystemDeleteMethod();
            }
            case CONTRACTID: {
                return SmartContractServiceGrpc.getSystemDeleteMethod();
            }
        }
        throw new IllegalStateException("requires an ID to be set, try calling setFileId or setContractId");
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setSystemDelete(this.builder);
        return true;
    }
}

