/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.TokenAssociateTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenID;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class TokenAssociateTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenAssociateTransaction> {
    private final TokenAssociateTransactionBody.Builder builder;

    public TokenAssociateTransaction() {
        this.builder = TokenAssociateTransactionBody.newBuilder();
        this.setMaxTransactionFee(new Hbar(5L));
    }

    TokenAssociateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (TokenAssociateTransactionBody.Builder)this.bodyBuilder.getTokenAssociate().toBuilder();
    }

    public AccountId getAccountId() {
        return AccountId.fromProtobuf(this.builder.getAccount());
    }

    public TokenAssociateTransaction setAccountId(AccountId accountId) {
        this.requireNotFrozen();
        this.builder.setAccount(accountId.toProtobuf());
        return this;
    }

    public List<TokenId> getTokenIds() {
        ArrayList<TokenId> list = new ArrayList<TokenId>(this.builder.getTokensCount());
        for (TokenID token : this.builder.getTokensList()) {
            list.add(TokenId.fromProtobuf(token));
        }
        return list;
    }

    public TokenAssociateTransaction setTokenIds(List<TokenId> tokens) {
        this.requireNotFrozen();
        this.builder.clearTokens();
        for (TokenId token : tokens) {
            this.builder.addTokens(token.toProtobuf());
        }
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getAssociateTokensMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenAssociate(this.builder);
        return true;
    }
}

