/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.TokenCreateTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public class TokenCreateTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenCreateTransaction> {
    private final TokenCreateTransactionBody.Builder builder;

    public TokenCreateTransaction() {
        this.builder = TokenCreateTransactionBody.newBuilder();
        this.setAutoRenewPeriod(DEFAULT_AUTO_RENEW_PERIOD);
        this.setMaxTransactionFee(new Hbar(30L));
    }

    TokenCreateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (TokenCreateTransactionBody.Builder)this.bodyBuilder.getTokenCreation().toBuilder();
    }

    public String getTokenName() {
        return this.builder.getName();
    }

    public TokenCreateTransaction setTokenName(String name) {
        this.requireNotFrozen();
        this.builder.setName(name);
        return this;
    }

    public String getTokenSymbol() {
        return this.builder.getSymbol();
    }

    public TokenCreateTransaction setTokenSymbol(String symbol) {
        this.requireNotFrozen();
        this.builder.setSymbol(symbol);
        return this;
    }

    public int getDecimals() {
        return this.builder.getDecimals();
    }

    public TokenCreateTransaction setDecimals(int decimals) {
        this.requireNotFrozen();
        this.builder.setDecimals(decimals);
        return this;
    }

    public long getInitialSupply() {
        return this.builder.getInitialSupply();
    }

    public TokenCreateTransaction setInitialSupply(long initialSupply) {
        this.requireNotFrozen();
        this.builder.setInitialSupply(initialSupply);
        return this;
    }

    public AccountId getTreasuryAccountId() {
        return AccountId.fromProtobuf(this.builder.getTreasury());
    }

    public TokenCreateTransaction setTreasuryAccountId(AccountId accountId) {
        this.requireNotFrozen();
        this.builder.setTreasury(accountId.toProtobuf());
        return this;
    }

    public Key getAdminKey() {
        return Key.fromProtobufKey(this.builder.getAdminKey());
    }

    public TokenCreateTransaction setAdminKey(Key key) {
        this.requireNotFrozen();
        this.builder.setAdminKey(key.toProtobufKey());
        return this;
    }

    public Key getKycKey() {
        return Key.fromProtobufKey(this.builder.getKycKey());
    }

    public TokenCreateTransaction setKycKey(Key key) {
        this.requireNotFrozen();
        this.builder.setKycKey(key.toProtobufKey());
        return this;
    }

    public Key getFreezeKey() {
        return Key.fromProtobufKey(this.builder.getFreezeKey());
    }

    public TokenCreateTransaction setFreezeKey(Key key) {
        this.requireNotFrozen();
        this.builder.setFreezeKey(key.toProtobufKey());
        return this;
    }

    public Key getWipeKey() {
        return Key.fromProtobufKey(this.builder.getWipeKey());
    }

    public TokenCreateTransaction setWipeKey(Key key) {
        this.requireNotFrozen();
        this.builder.setWipeKey(key.toProtobufKey());
        return this;
    }

    public Key getSupplyKey() {
        return Key.fromProtobufKey(this.builder.getSupplyKey());
    }

    public TokenCreateTransaction setSupplyKey(Key key) {
        this.requireNotFrozen();
        this.builder.setSupplyKey(key.toProtobufKey());
        return this;
    }

    public boolean getFreezeDefault() {
        return this.builder.getFreezeDefault();
    }

    public TokenCreateTransaction setFreezeDefault(boolean freezeDefault) {
        this.requireNotFrozen();
        this.builder.setFreezeDefault(freezeDefault);
        return this;
    }

    public Instant getExpirationTime() {
        return InstantConverter.fromProtobuf(this.builder.getExpiry());
    }

    public TokenCreateTransaction setExpirationTime(Instant expirationTime) {
        this.requireNotFrozen();
        this.builder.clearAutoRenewPeriod();
        this.builder.setExpiry(InstantConverter.toProtobuf(expirationTime));
        return this;
    }

    public AccountId getAutoRenewAccountId() {
        return AccountId.fromProtobuf(this.builder.getAutoRenewAccount());
    }

    public TokenCreateTransaction setAutoRenewAccountId(AccountId accountId) {
        this.requireNotFrozen();
        this.builder.setAutoRenewAccount(accountId.toProtobuf());
        return this;
    }

    public Duration getAutoRenewPeriod() {
        return DurationConverter.fromProtobuf(this.builder.getAutoRenewPeriod());
    }

    public TokenCreateTransaction setAutoRenewPeriod(Duration period) {
        this.requireNotFrozen();
        this.builder.setAutoRenewPeriod(DurationConverter.toProtobuf(period));
        return this;
    }

    public String getTokenMemo() {
        return this.builder.getMemo();
    }

    public TokenCreateTransaction setTokenMemo(String memo) {
        this.requireNotFrozen();
        this.builder.setMemo(memo);
        return this;
    }

    @Override
    public TokenCreateTransaction freezeWith(@Nullable Client client) {
        if (this.builder.hasAutoRenewPeriod() && !this.builder.hasAutoRenewAccount() && client != null && client.getOperatorAccountId() != null) {
            this.builder.setAutoRenewAccount(client.getOperatorAccountId().toProtobuf());
        }
        return (TokenCreateTransaction)super.freezeWith(client);
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getCreateTokenMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenCreation(this.builder);
        return true;
    }
}

