/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.TokenDissociateTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenID;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class TokenDissociateTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenDissociateTransaction> {
    private final TokenDissociateTransactionBody.Builder builder;

    public TokenDissociateTransaction() {
        this.builder = TokenDissociateTransactionBody.newBuilder();
        this.setMaxTransactionFee(new Hbar(5L));
    }

    TokenDissociateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (TokenDissociateTransactionBody.Builder)this.bodyBuilder.getTokenDissociate().toBuilder();
    }

    public AccountId getAccountId() {
        return AccountId.fromProtobuf(this.builder.getAccount());
    }

    public TokenDissociateTransaction setAccountId(AccountId accountId) {
        this.requireNotFrozen();
        this.builder.setAccount(accountId.toProtobuf());
        return this;
    }

    public List<TokenId> getTokenIds() {
        ArrayList<TokenId> list = new ArrayList<TokenId>(this.builder.getTokensCount());
        for (TokenID token : this.builder.getTokensList()) {
            list.add(TokenId.fromProtobuf(token));
        }
        return list;
    }

    public TokenDissociateTransaction setTokenIds(List<TokenId> tokens) {
        this.requireNotFrozen();
        this.builder.clearTokens();
        for (TokenId token : tokens) {
            this.builder.addTokens(token.toProtobuf());
        }
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getDissociateTokensMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenDissociate(this.builder);
        return true;
    }
}

