/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.proto.TokenFreezeStatus;
import com.hedera.hashgraph.sdk.proto.TokenGetInfoResponse;
import com.hedera.hashgraph.sdk.proto.TokenKycStatus;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;

public class TokenInfo {
    public final TokenId tokenId;
    public final String name;
    public final String symbol;
    public final int decimals;
    public final long totalSupply;
    public final AccountId treasuryAccountId;
    @Nullable
    public final Key adminKey;
    @Nullable
    public final Key kycKey;
    @Nullable
    public final Key freezeKey;
    @Nullable
    public final Key wipeKey;
    @Nullable
    public final Key supplyKey;
    @Nullable
    public final Boolean defaultFreezeStatus;
    @Nullable
    public final Boolean defaultKycStatus;
    public final boolean isDeleted;
    @Nullable
    public final AccountId autoRenewAccount;
    @Nullable
    public final Duration autoRenewPeriod;
    @Nullable
    public final Instant expirationTime;

    private TokenInfo(TokenId tokenId, String name, String symbol, int decimals, long totalSupply, AccountId treasuryAccountId, @Nullable Key adminKey, @Nullable Key kycKey, @Nullable Key freezeKey, @Nullable Key wipeKey, @Nullable Key supplyKey, @Nullable Boolean defaultFreezeStatus, @Nullable Boolean defaultKycStatus, boolean isDeleted, @Nullable AccountId autoRenewAccount, @Nullable Duration autoRenewPeriod, @Nullable Instant expirationTime) {
        this.tokenId = tokenId;
        this.name = name;
        this.symbol = symbol;
        this.decimals = decimals;
        this.totalSupply = totalSupply;
        this.treasuryAccountId = treasuryAccountId;
        this.adminKey = adminKey;
        this.kycKey = kycKey;
        this.freezeKey = freezeKey;
        this.wipeKey = wipeKey;
        this.supplyKey = supplyKey;
        this.defaultFreezeStatus = defaultFreezeStatus;
        this.defaultKycStatus = defaultKycStatus;
        this.isDeleted = isDeleted;
        this.autoRenewAccount = autoRenewAccount;
        this.autoRenewPeriod = autoRenewPeriod;
        this.expirationTime = expirationTime;
    }

    @Nullable
    static Boolean freezeStatusFromProtobuf(TokenFreezeStatus freezeStatus) {
        return freezeStatus == TokenFreezeStatus.FreezeNotApplicable ? null : Boolean.valueOf(freezeStatus == TokenFreezeStatus.Frozen);
    }

    @Nullable
    static Boolean kycStatusFromProtobuf(TokenKycStatus kycStatus) {
        return kycStatus == TokenKycStatus.KycNotApplicable ? null : Boolean.valueOf(kycStatus == TokenKycStatus.Granted);
    }

    static TokenInfo fromProtobuf(TokenGetInfoResponse response) {
        com.hedera.hashgraph.sdk.proto.TokenInfo info = response.getTokenInfo();
        return new TokenInfo(TokenId.fromProtobuf(info.getTokenId()), info.getName(), info.getSymbol(), info.getDecimals(), info.getTotalSupply(), AccountId.fromProtobuf(info.getTreasury()), info.hasAdminKey() ? Key.fromProtobufKey(info.getAdminKey()) : null, info.hasKycKey() ? Key.fromProtobufKey(info.getKycKey()) : null, info.hasFreezeKey() ? Key.fromProtobufKey(info.getFreezeKey()) : null, info.hasWipeKey() ? Key.fromProtobufKey(info.getWipeKey()) : null, info.hasSupplyKey() ? Key.fromProtobufKey(info.getSupplyKey()) : null, TokenInfo.freezeStatusFromProtobuf(info.getDefaultFreezeStatus()), TokenInfo.kycStatusFromProtobuf(info.getDefaultKycStatus()), info.getDeleted(), info.hasAutoRenewAccount() ? AccountId.fromProtobuf(info.getAutoRenewAccount()) : null, info.hasAutoRenewPeriod() ? DurationConverter.fromProtobuf(info.getAutoRenewPeriod()) : null, info.hasExpiry() ? InstantConverter.fromProtobuf(info.getExpiry()) : null);
    }

    public static TokenInfo fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TokenInfo.fromProtobuf((TokenGetInfoResponse)((TokenGetInfoResponse.Builder)TokenGetInfoResponse.parseFrom(bytes).toBuilder()).build());
    }

    @Nullable
    static TokenFreezeStatus freezeStatusToProtobuf(@Nullable Boolean freezeStatus) {
        return freezeStatus == null ? TokenFreezeStatus.FreezeNotApplicable : (freezeStatus != false ? TokenFreezeStatus.Frozen : TokenFreezeStatus.Unfrozen);
    }

    @Nullable
    static TokenKycStatus kycStatusToProtobuf(@Nullable Boolean kycStatus) {
        return kycStatus == null ? TokenKycStatus.KycNotApplicable : (kycStatus != false ? TokenKycStatus.Granted : TokenKycStatus.Revoked);
    }

    TokenGetInfoResponse toProtobuf() {
        return (TokenGetInfoResponse)TokenGetInfoResponse.newBuilder().setTokenInfo(com.hedera.hashgraph.sdk.proto.TokenInfo.newBuilder().setTokenId(this.tokenId.toProtobuf()).setName(this.name).setSymbol(this.symbol).setDecimals(this.decimals).setTotalSupply(this.totalSupply).setTreasury(this.treasuryAccountId.toProtobuf()).setAdminKey(this.adminKey != null ? this.adminKey.toProtobufKey() : null).setKycKey(this.kycKey != null ? this.kycKey.toProtobufKey() : null).setFreezeKey(this.freezeKey != null ? this.freezeKey.toProtobufKey() : null).setWipeKey(this.wipeKey != null ? this.wipeKey.toProtobufKey() : null).setSupplyKey(this.supplyKey != null ? this.supplyKey.toProtobufKey() : null).setDefaultFreezeStatus(TokenInfo.freezeStatusToProtobuf(this.defaultFreezeStatus)).setDefaultKycStatus(TokenInfo.kycStatusToProtobuf(this.defaultKycStatus)).setDeleted(this.isDeleted).setAutoRenewAccount(this.autoRenewAccount != null ? this.autoRenewAccount.toProtobuf() : null).setAutoRenewPeriod(this.autoRenewPeriod != null ? DurationConverter.toProtobuf(this.autoRenewPeriod) : null).setExpiry(this.expirationTime != null ? InstantConverter.toProtobuf(this.expirationTime) : null)).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tokenId", (Object)this.tokenId).add("name", (Object)this.name).add("symbol", (Object)this.symbol).add("decimals", this.decimals).add("totalSupply", this.totalSupply).add("treasuryAccountId", (Object)this.treasuryAccountId).add("adminKey", (Object)this.adminKey).add("kycKey", (Object)this.kycKey).add("freezeKey", (Object)this.freezeKey).add("wipeKey", (Object)this.wipeKey).add("supplyKey", (Object)this.supplyKey).add("defaultFreezeStatus", (Object)this.defaultFreezeStatus).add("defaultKycStatus", (Object)this.defaultKycStatus).add("isDeleted", this.isDeleted).add("autoRenewAccount", (Object)this.autoRenewAccount).add("autoRenewPeriod", (Object)this.autoRenewPeriod).add("expirationTime", (Object)this.expirationTime).toString();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

