/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.StringValue;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.TokenUpdateTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;

public class TokenUpdateTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenUpdateTransaction> {
    private final TokenUpdateTransactionBody.Builder builder;

    public TokenUpdateTransaction() {
        this.builder = TokenUpdateTransactionBody.newBuilder();
    }

    TokenUpdateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (TokenUpdateTransactionBody.Builder)this.bodyBuilder.getTokenUpdate().toBuilder();
    }

    public TokenId getTokenId() {
        return TokenId.fromProtobuf(this.builder.getToken());
    }

    public TokenUpdateTransaction setTokenId(TokenId tokenId) {
        this.requireNotFrozen();
        this.builder.setToken(tokenId.toProtobuf());
        return this;
    }

    public String getTokenName() {
        return this.builder.getName();
    }

    public TokenUpdateTransaction setTokenName(String name) {
        this.requireNotFrozen();
        this.builder.setName(name);
        return this;
    }

    public String getTokenSymbol() {
        return this.builder.getSymbol();
    }

    public TokenUpdateTransaction setTokenSymbol(String symbol) {
        this.requireNotFrozen();
        this.builder.setSymbol(symbol);
        return this;
    }

    public AccountId getTreasuryAccountId() {
        return AccountId.fromProtobuf(this.builder.getTreasury());
    }

    public TokenUpdateTransaction setTreasuryAccountId(AccountId accountId) {
        this.requireNotFrozen();
        this.builder.setTreasury(accountId.toProtobuf());
        return this;
    }

    public Key getAdminKey() {
        return Key.fromProtobufKey(this.builder.getAdminKey());
    }

    public TokenUpdateTransaction setAdminKey(Key key) {
        this.requireNotFrozen();
        this.builder.setAdminKey(key.toProtobufKey());
        return this;
    }

    public Key getKycKey() {
        return Key.fromProtobufKey(this.builder.getKycKey());
    }

    public TokenUpdateTransaction setKycKey(Key key) {
        this.requireNotFrozen();
        this.builder.setKycKey(key.toProtobufKey());
        return this;
    }

    public Key getFreezeKey() {
        return Key.fromProtobufKey(this.builder.getFreezeKey());
    }

    public TokenUpdateTransaction setFreezeKey(Key key) {
        this.requireNotFrozen();
        this.builder.setFreezeKey(key.toProtobufKey());
        return this;
    }

    public Key getWipeKey() {
        return Key.fromProtobufKey(this.builder.getWipeKey());
    }

    public TokenUpdateTransaction setWipeKey(Key key) {
        this.requireNotFrozen();
        this.builder.setWipeKey(key.toProtobufKey());
        return this;
    }

    public Key getSupplyKey() {
        return Key.fromProtobufKey(this.builder.getSupplyKey());
    }

    public TokenUpdateTransaction setSupplyKey(Key key) {
        this.requireNotFrozen();
        this.builder.setSupplyKey(key.toProtobufKey());
        return this;
    }

    public Instant getExpirationTime() {
        return InstantConverter.fromProtobuf(this.builder.getExpiry());
    }

    public TokenUpdateTransaction setExpirationTime(Instant expirationTime) {
        this.requireNotFrozen();
        this.builder.setExpiry(InstantConverter.toProtobuf(expirationTime));
        return this;
    }

    public AccountId getAutoRenewAccountId() {
        return AccountId.fromProtobuf(this.builder.getAutoRenewAccount());
    }

    public TokenUpdateTransaction setAutoRenewAccountId(AccountId accountId) {
        this.requireNotFrozen();
        this.builder.setAutoRenewAccount(accountId.toProtobuf());
        return this;
    }

    public Duration getAutoRenewPeriod() {
        return DurationConverter.fromProtobuf(this.builder.getAutoRenewPeriod());
    }

    public TokenUpdateTransaction setAutoRenewPeriod(Duration period) {
        this.requireNotFrozen();
        this.builder.setAutoRenewPeriod(DurationConverter.toProtobuf(period));
        return this;
    }

    public String getTokenMemo() {
        return this.builder.getMemo().getValue();
    }

    public TokenUpdateTransaction setTokenMemo(String memo) {
        this.requireNotFrozen();
        this.builder.setMemo(StringValue.of((String)memo));
        return this;
    }

    public TokenUpdateTransaction clearMemo() {
        this.requireNotFrozen();
        this.builder.clearMemo();
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getUpdateTokenMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenUpdate(this.builder);
        return true;
    }
}

