/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ConsensusCreateTopicTransactionBody;
import com.hedera.hashgraph.sdk.proto.ConsensusServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class TopicCreateTransaction
extends com.hedera.hashgraph.sdk.Transaction<TopicCreateTransaction> {
    private final ConsensusCreateTopicTransactionBody.Builder builder;

    public TopicCreateTransaction() {
        this.builder = ConsensusCreateTopicTransactionBody.newBuilder();
        this.setAutoRenewPeriod(DEFAULT_AUTO_RENEW_PERIOD);
    }

    TopicCreateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (ConsensusCreateTopicTransactionBody.Builder)this.bodyBuilder.getConsensusCreateTopic().toBuilder();
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return ConsensusServiceGrpc.getCreateTopicMethod();
    }

    public String getTopicMemo() {
        return this.builder.getMemo();
    }

    public TopicCreateTransaction setTopicMemo(String memo) {
        this.requireNotFrozen();
        this.builder.setMemo(memo);
        return this;
    }

    @Nullable
    public Key getAdminKey() {
        return this.builder.hasAdminKey() ? Key.fromProtobufKey(this.builder.getAdminKey()) : null;
    }

    public TopicCreateTransaction setAdminKey(Key adminKey) {
        this.requireNotFrozen();
        this.builder.setAdminKey(adminKey.toProtobufKey());
        return this;
    }

    @Nullable
    public Key getSubmitKey() {
        return this.builder.hasSubmitKey() ? Key.fromProtobufKey(this.builder.getSubmitKey()) : null;
    }

    public TopicCreateTransaction setSubmitKey(Key submitKey) {
        this.requireNotFrozen();
        this.builder.setSubmitKey(submitKey.toProtobufKey());
        return this;
    }

    @Nullable
    public Duration getAutoRenewPeriod() {
        return this.builder.hasAutoRenewPeriod() ? DurationConverter.fromProtobuf(this.builder.getAutoRenewPeriod()) : null;
    }

    public TopicCreateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        this.requireNotFrozen();
        this.builder.setAutoRenewPeriod(DurationConverter.toProtobuf(autoRenewPeriod));
        return this;
    }

    @Nullable
    public AccountId getAutoRenewAccountId() {
        return this.builder.hasAutoRenewAccount() ? AccountId.fromProtobuf(this.builder.getAutoRenewAccount()) : null;
    }

    public TopicCreateTransaction setAutoRenewAccountId(AccountId autoRenewAccountId) {
        this.requireNotFrozen();
        this.builder.setAutoRenewAccount(autoRenewAccountId.toProtobuf());
        return this;
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setConsensusCreateTopic(this.builder);
        return true;
    }
}

