/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.StringValue;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.TopicId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.AccountID;
import com.hedera.hashgraph.sdk.proto.ConsensusServiceGrpc;
import com.hedera.hashgraph.sdk.proto.ConsensusUpdateTopicTransactionBody;
import com.hedera.hashgraph.sdk.proto.Key;
import com.hedera.hashgraph.sdk.proto.KeyList;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class TopicUpdateTransaction
extends com.hedera.hashgraph.sdk.Transaction<TopicUpdateTransaction> {
    private final ConsensusUpdateTopicTransactionBody.Builder builder;

    public TopicUpdateTransaction() {
        this.builder = ConsensusUpdateTopicTransactionBody.newBuilder();
    }

    TopicUpdateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (ConsensusUpdateTopicTransactionBody.Builder)this.bodyBuilder.getConsensusUpdateTopic().toBuilder();
    }

    @Nullable
    public TopicId getTopicId() {
        return this.builder.hasTopicID() ? TopicId.fromProtobuf(this.builder.getTopicID()) : null;
    }

    public TopicUpdateTransaction setTopicId(TopicId topicId) {
        this.requireNotFrozen();
        this.builder.setTopicID(topicId.toProtobuf());
        return this;
    }

    @Nullable
    public String getTopicMemo() {
        return this.builder.hasMemo() ? this.builder.getMemo().getValue() : null;
    }

    public TopicUpdateTransaction setTopicMemo(String memo) {
        this.requireNotFrozen();
        this.builder.setMemo(StringValue.of((String)memo));
        return this;
    }

    public TopicUpdateTransaction clearTopicMemo() {
        this.requireNotFrozen();
        this.builder.setMemo(StringValue.of((String)""));
        return this;
    }

    @Nullable
    public com.hedera.hashgraph.sdk.Key getAdminKey() {
        return this.builder.hasAdminKey() ? com.hedera.hashgraph.sdk.Key.fromProtobufKey(this.builder.getAdminKey()) : null;
    }

    public TopicUpdateTransaction setAdminKey(com.hedera.hashgraph.sdk.Key adminKey) {
        this.requireNotFrozen();
        this.builder.setAdminKey(adminKey.toProtobufKey());
        return this;
    }

    public TopicUpdateTransaction clearAdminKey() {
        this.requireNotFrozen();
        this.builder.setAdminKey((Key)Key.newBuilder().setKeyList(KeyList.getDefaultInstance()).build());
        return this;
    }

    @Nullable
    public com.hedera.hashgraph.sdk.Key getSubmitKey() {
        return this.builder.hasSubmitKey() ? com.hedera.hashgraph.sdk.Key.fromProtobufKey(this.builder.getSubmitKey()) : null;
    }

    public TopicUpdateTransaction setSubmitKey(com.hedera.hashgraph.sdk.Key submitKey) {
        this.requireNotFrozen();
        this.builder.setSubmitKey(submitKey.toProtobufKey());
        return this;
    }

    public TopicUpdateTransaction clearSubmitKey() {
        this.requireNotFrozen();
        this.builder.setSubmitKey((Key)Key.newBuilder().setKeyList(KeyList.getDefaultInstance()).build());
        return this;
    }

    @Nullable
    public Duration getAutoRenewPeriod() {
        return this.builder.hasAutoRenewPeriod() ? DurationConverter.fromProtobuf(this.builder.getAutoRenewPeriod()) : null;
    }

    public TopicUpdateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        this.requireNotFrozen();
        this.builder.setAutoRenewPeriod(DurationConverter.toProtobuf(autoRenewPeriod));
        return this;
    }

    @Nullable
    public AccountId getAutoRenewAccountId() {
        return this.builder.hasAutoRenewAccount() ? AccountId.fromProtobuf(this.builder.getAutoRenewAccount()) : null;
    }

    public TopicUpdateTransaction setAutoRenewAccountId(AccountId autoRenewAccountId) {
        this.requireNotFrozen();
        this.builder.setAutoRenewAccount(autoRenewAccountId.toProtobuf());
        return this;
    }

    public TopicUpdateTransaction clearAutoRenewAccountId(AccountId autoRenewAccountId) {
        this.requireNotFrozen();
        this.builder.setAutoRenewAccount(AccountID.getDefaultInstance());
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return ConsensusServiceGrpc.getUpdateTopicMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setConsensusUpdateTopic(this.builder);
        return true;
    }
}

