/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Query;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionReceipt;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Query;
import com.hedera.hashgraph.sdk.proto.QueryHeader;
import com.hedera.hashgraph.sdk.proto.Response;
import com.hedera.hashgraph.sdk.proto.ResponseCodeEnum;
import com.hedera.hashgraph.sdk.proto.ResponseHeader;
import com.hedera.hashgraph.sdk.proto.TransactionGetReceiptQuery;
import io.grpc.MethodDescriptor;

public final class TransactionReceiptQuery
extends Query<TransactionReceipt, TransactionReceiptQuery> {
    private final TransactionGetReceiptQuery.Builder builder = TransactionGetReceiptQuery.newBuilder();

    @Override
    public TransactionId getTransactionId() {
        return TransactionId.fromProtobuf(this.builder.getTransactionID());
    }

    public TransactionReceiptQuery setTransactionId(TransactionId transactionId) {
        this.builder.setTransactionID(transactionId.toProtobuf());
        return this;
    }

    @Override
    boolean isPaymentRequired() {
        return false;
    }

    @Override
    void onMakeRequest(Query.Builder queryBuilder, QueryHeader header) {
        queryBuilder.setTransactionGetReceipt(this.builder.setHeader(header));
    }

    @Override
    Status mapResponseStatus(Response response) {
        ResponseCodeEnum preCheckCode = response.getTransactionGetReceipt().getReceipt().getStatus();
        return Status.valueOf(preCheckCode);
    }

    @Override
    TransactionReceipt mapResponse(Response response, AccountId nodeId, com.hedera.hashgraph.sdk.proto.Query request) {
        return TransactionReceipt.fromProtobuf(response.getTransactionGetReceipt().getReceipt());
    }

    @Override
    QueryHeader mapRequestHeader(com.hedera.hashgraph.sdk.proto.Query request) {
        return request.getTransactionGetReceipt().getHeader();
    }

    @Override
    ResponseHeader mapResponseHeader(Response response) {
        return response.getTransactionGetReceipt().getHeader();
    }

    @Override
    MethodDescriptor<com.hedera.hashgraph.sdk.proto.Query, Response> getMethodDescriptor() {
        return CryptoServiceGrpc.getGetTransactionReceiptsMethod();
    }

    @Override
    boolean shouldRetry(Status status, Response response) {
        Status receiptStatus = Status.valueOf(response.getTransactionGetReceipt().getReceipt().getStatus());
        switch (receiptStatus) {
            case BUSY: 
            case UNKNOWN: 
            case OK: 
            case RECEIPT_NOT_FOUND: {
                return true;
            }
        }
        return false;
    }
}

