/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.AccountAmount;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.CryptoTransferTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenTransferList;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.proto.TransferList;
import io.grpc.MethodDescriptor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class TransferTransaction
extends com.hedera.hashgraph.sdk.Transaction<TransferTransaction> {
    private final CryptoTransferTransactionBody.Builder builder;
    private final Map<TokenId, Map<AccountId, Long>> tokenTransfers = new HashMap<TokenId, Map<AccountId, Long>>();
    private final Map<AccountId, Hbar> hbarTransfers = new HashMap<AccountId, Hbar>();

    public TransferTransaction() {
        this.builder = CryptoTransferTransactionBody.newBuilder();
        this.setMaxTransactionFee(new Hbar(1L));
    }

    TransferTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (CryptoTransferTransactionBody.Builder)this.bodyBuilder.getCryptoTransfer().toBuilder();
        for (AccountAmount transfer : this.bodyBuilder.getCryptoTransfer().getTransfers().getAccountAmountsList()) {
            this.hbarTransfers.merge(AccountId.fromProtobuf(transfer.getAccountID()), Hbar.fromTinybars(transfer.getAmount()), (a, b) -> Hbar.fromTinybars(a.toTinybars() + b.toTinybars()));
        }
        for (TokenTransferList tokenTransferList : this.bodyBuilder.getCryptoTransfer().getTokenTransfersList()) {
            Map list = this.tokenTransfers.computeIfAbsent(TokenId.fromProtobuf(tokenTransferList.getToken()), k -> new HashMap());
            for (AccountAmount aa : tokenTransferList.getTransfersList()) {
                list.merge(AccountId.fromProtobuf(aa.getAccountID()), aa.getAmount(), Long::sum);
            }
        }
    }

    public Map<TokenId, Map<AccountId, Long>> getTokenTransfers() {
        return this.tokenTransfers;
    }

    public TransferTransaction addTokenTransfer(TokenId tokenId, AccountId accountId, long value) {
        this.requireNotFrozen();
        this.tokenTransfers.computeIfAbsent(tokenId, k -> new HashMap()).merge(accountId, value, Long::sum);
        return this;
    }

    public Map<AccountId, Hbar> getHbarTransfers() {
        return this.hbarTransfers;
    }

    public TransferTransaction addHbarTransfer(AccountId accountId, Hbar value) {
        this.requireNotFrozen();
        this.hbarTransfers.merge(accountId, value, (a, b) -> Hbar.fromTinybars(a.toTinybars() + b.toTinybars()));
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getCryptoTransferMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        for (Map.Entry<TokenId, Map<AccountId, Long>> entry : this.tokenTransfers.entrySet()) {
            TokenTransferList.Builder list = TokenTransferList.newBuilder().setToken(entry.getKey().toProtobuf());
            for (Map.Entry<AccountId, Long> aa : entry.getValue().entrySet()) {
                list.addTransfers(AccountAmount.newBuilder().setAccountID(aa.getKey().toProtobuf()).setAmount(aa.getValue()));
            }
            this.builder.addTokenTransfers(list);
        }
        TransferList.Builder list = TransferList.newBuilder();
        for (Map.Entry<AccountId, Hbar> entry : this.hbarTransfers.entrySet()) {
            list.addAccountAmounts(AccountAmount.newBuilder().setAccountID(entry.getKey().toProtobuf()).setAmount(entry.getValue().toTinybars()));
        }
        this.builder.setTransfers(list);
        bodyBuilder.setCryptoTransfer(this.builder);
        return true;
    }
}

