/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface WithExecute<O> {
    public CompletableFuture<O> executeAsync(Client var1);

    default public void executeAsync(Client client, BiConsumer<O, Throwable> callback) {
        this.executeAsync(client, client.requestTimeout, callback);
    }

    default public void executeAsync(Client client, Duration timeout, BiConsumer<O, Throwable> callback) {
        this.executeAsync(client).orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).whenComplete((BiConsumer)callback);
    }

    default public void executeAsync(Client client, Consumer<O> onSuccess, Consumer<Throwable> onFailure) {
        this.executeAsync(client, client.requestTimeout, onSuccess, onFailure);
    }

    default public void executeAsync(Client client, Duration timeout, Consumer<O> onSuccess, Consumer<Throwable> onFailure) {
        this.executeAsync(client).orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).whenComplete((output, error) -> {
            if (error != null) {
                onFailure.accept((Throwable)error);
            } else {
                onSuccess.accept(output);
            }
        });
    }

    default public O execute(Client client) throws TimeoutException, PrecheckStatusException {
        return this.execute(client, client.requestTimeout);
    }

    default public O execute(Client client, Duration timeout) throws TimeoutException, PrecheckStatusException {
        try {
            return this.executeAsync(client).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new RuntimeException(e);
            }
            if (cause instanceof PrecheckStatusException) {
                throw (PrecheckStatusException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

