/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.TransactionResponse;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface WithExecuteAll {
    public CompletableFuture<List<TransactionResponse>> executeAllAsync(Client var1);

    default public void executeAllAsync(Client client, BiConsumer<List<TransactionResponse>, Throwable> callback) {
        this.executeAllAsync(client, client.requestTimeout, callback);
    }

    default public void executeAllAsync(Client client, Duration timeout, BiConsumer<List<TransactionResponse>, Throwable> callback) {
        this.executeAllAsync(client).orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).whenComplete((BiConsumer)callback);
    }

    default public void executeAllAsync(Client client, Consumer<List<TransactionResponse>> onSuccess, Consumer<Throwable> onFailure) {
        this.executeAllAsync(client, client.requestTimeout, onSuccess, onFailure);
    }

    default public void executeAllAsync(Client client, Duration timeout, Consumer<List<TransactionResponse>> onSuccess, Consumer<Throwable> onFailure) {
        this.executeAllAsync(client).orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).whenComplete((output, error) -> {
            if (error != null) {
                onFailure.accept((Throwable)error);
            } else {
                onSuccess.accept((List<TransactionResponse>)output);
            }
        });
    }

    default public List<TransactionResponse> executeAll(Client client) throws TimeoutException, PrecheckStatusException {
        return this.executeAll(client, client.requestTimeout);
    }

    default public List<TransactionResponse> executeAll(Client client, Duration timeout) throws TimeoutException, PrecheckStatusException {
        try {
            return this.executeAllAsync(client).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new RuntimeException(e);
            }
            if (cause instanceof PrecheckStatusException) {
                throw (PrecheckStatusException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

