/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.HbarAllowance;
import com.hedera.hashgraph.sdk.NftId;
import com.hedera.hashgraph.sdk.TokenAllowance;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TokenNftAllowance;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.CryptoAdjustAllowanceTransactionBody;
import com.hedera.hashgraph.sdk.proto.CryptoAllowance;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.NftAllowance;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public class AccountAllowanceAdjustTransaction
extends com.hedera.hashgraph.sdk.Transaction<AccountAllowanceAdjustTransaction> {
    private final List<HbarAllowance> hbarAllowances = new ArrayList<HbarAllowance>();
    private final List<TokenAllowance> tokenAllowances = new ArrayList<TokenAllowance>();
    private final List<TokenNftAllowance> nftAllowances = new ArrayList<TokenNftAllowance>();
    private final Map<String, Map<TokenId, Integer>> nftMap = new HashMap<String, Map<TokenId, Integer>>();

    public AccountAllowanceAdjustTransaction() {
    }

    AccountAllowanceAdjustTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    AccountAllowanceAdjustTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    private void initFromTransactionBody() {
        CryptoAdjustAllowanceTransactionBody body = this.sourceTransactionBody.getCryptoAdjustAllowance();
        for (CryptoAllowance cryptoAllowance : body.getCryptoAllowancesList()) {
            this.hbarAllowances.add(HbarAllowance.fromProtobuf(cryptoAllowance));
        }
        for (com.hedera.hashgraph.sdk.proto.TokenAllowance tokenAllowance : body.getTokenAllowancesList()) {
            this.tokenAllowances.add(TokenAllowance.fromProtobuf(tokenAllowance));
        }
        for (NftAllowance nftAllowance : body.getNftAllowancesList()) {
            if (nftAllowance.hasApprovedForAll()) {
                this.nftAllowances.add(TokenNftAllowance.fromProtobuf(nftAllowance));
                continue;
            }
            this.getNftSerials(AccountId.fromProtobuf(nftAllowance.getOwner()), AccountId.fromProtobuf(nftAllowance.getSpender()), TokenId.fromProtobuf(nftAllowance.getTokenId())).addAll(nftAllowance.getSerialNumbersList());
        }
    }

    private AccountAllowanceAdjustTransaction adjustHbarAllowance(@Nullable AccountId ownerAccountId, AccountId spenderAccountId, Hbar amount) {
        this.requireNotFrozen();
        this.hbarAllowances.add(new HbarAllowance(ownerAccountId, Objects.requireNonNull(spenderAccountId), amount));
        return this;
    }

    @Deprecated
    public AccountAllowanceAdjustTransaction addHbarAllowance(AccountId spenderAccountId, Hbar amount) {
        return this.adjustHbarAllowance(null, spenderAccountId, Objects.requireNonNull(amount));
    }

    public AccountAllowanceAdjustTransaction grantHbarAllowance(AccountId ownerAccountId, AccountId spenderAccountId, Hbar amount) {
        Objects.requireNonNull(amount);
        if (amount.compareTo(Hbar.ZERO) < 0) {
            throw new IllegalArgumentException("amount passed to grantHbarAllowance must be positive");
        }
        return this.adjustHbarAllowance(Objects.requireNonNull(ownerAccountId), spenderAccountId, amount);
    }

    public AccountAllowanceAdjustTransaction revokeHbarAllowance(AccountId ownerAccountId, AccountId spenderAccountId, Hbar amount) {
        Objects.requireNonNull(amount);
        if (amount.compareTo(Hbar.ZERO) < 0) {
            throw new IllegalArgumentException("amount passed to revokeHbarAllowance must be positive");
        }
        return this.adjustHbarAllowance(Objects.requireNonNull(ownerAccountId), spenderAccountId, amount.negated());
    }

    public List<HbarAllowance> getHbarAllowances() {
        return new ArrayList<HbarAllowance>(this.hbarAllowances);
    }

    private AccountAllowanceAdjustTransaction adjustTokenAllowance(TokenId tokenId, @Nullable AccountId ownerAccountId, AccountId spenderAccountId, long amount) {
        this.requireNotFrozen();
        this.tokenAllowances.add(new TokenAllowance(Objects.requireNonNull(tokenId), ownerAccountId, Objects.requireNonNull(spenderAccountId), amount));
        return this;
    }

    @Deprecated
    public AccountAllowanceAdjustTransaction addTokenAllowance(TokenId tokenId, AccountId spenderAccountId, long amount) {
        return this.adjustTokenAllowance(tokenId, null, spenderAccountId, amount);
    }

    public AccountAllowanceAdjustTransaction grantTokenAllowance(TokenId tokenId, AccountId ownerAccountId, AccountId spenderAccountId, @Nonnegative long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("amount passed to grantTokenAllowance must be positive");
        }
        return this.adjustTokenAllowance(tokenId, Objects.requireNonNull(ownerAccountId), spenderAccountId, amount);
    }

    public AccountAllowanceAdjustTransaction revokeTokenAllowance(TokenId tokenId, AccountId ownerAccountId, AccountId spenderAccountId, @Nonnegative long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("amount passed to revokeTokenAllowance must be positive");
        }
        return this.adjustTokenAllowance(tokenId, Objects.requireNonNull(ownerAccountId), spenderAccountId, -amount);
    }

    public List<TokenAllowance> getTokenAllowances() {
        return new ArrayList<TokenAllowance>(this.tokenAllowances);
    }

    private static String ownerToString(@Nullable AccountId ownerAccountId) {
        return ownerAccountId != null ? ownerAccountId.toString() : "FEE_PAYER";
    }

    private List<Long> getNftSerials(@Nullable AccountId ownerAccountId, AccountId spenderAccountId, TokenId tokenId) {
        String key = AccountAllowanceAdjustTransaction.ownerToString(ownerAccountId) + ":" + spenderAccountId;
        if (this.nftMap.containsKey(key)) {
            Map<TokenId, Integer> innerMap = this.nftMap.get(key);
            if (innerMap.containsKey(tokenId)) {
                return Objects.requireNonNull(this.nftAllowances.get((int)innerMap.get((Object)tokenId).intValue()).serialNumbers);
            }
            return this.newNftSerials(ownerAccountId, spenderAccountId, tokenId, innerMap);
        }
        HashMap<TokenId, Integer> innerMap = new HashMap<TokenId, Integer>();
        this.nftMap.put(key, innerMap);
        return this.newNftSerials(ownerAccountId, spenderAccountId, tokenId, innerMap);
    }

    private List<Long> newNftSerials(@Nullable AccountId ownerAccountId, AccountId spenderAccountId, TokenId tokenId, Map<TokenId, Integer> innerMap) {
        innerMap.put(tokenId, this.nftAllowances.size());
        TokenNftAllowance newAllowance = new TokenNftAllowance(tokenId, ownerAccountId, spenderAccountId, new ArrayList<Long>(), null);
        this.nftAllowances.add(newAllowance);
        return newAllowance.serialNumbers;
    }

    private AccountAllowanceAdjustTransaction adjustNftAllowance(TokenId tokenId, long serial, @Nullable AccountId ownerAccountId, AccountId spenderAccountId) {
        this.requireNotFrozen();
        this.getNftSerials(ownerAccountId, Objects.requireNonNull(spenderAccountId), tokenId).add(serial);
        return this;
    }

    private AccountAllowanceAdjustTransaction adjustNftAllowanceAllSerials(TokenId tokenId, boolean allSerials, @Nullable AccountId ownerAccountId, AccountId spenderAccountId) {
        this.requireNotFrozen();
        this.nftAllowances.add(new TokenNftAllowance(Objects.requireNonNull(tokenId), ownerAccountId, Objects.requireNonNull(spenderAccountId), Collections.emptyList(), allSerials));
        return this;
    }

    @Deprecated
    public AccountAllowanceAdjustTransaction addTokenNftAllowance(NftId nftId, AccountId spenderAccountId) {
        Objects.requireNonNull(nftId);
        return this.adjustNftAllowance(nftId.tokenId, nftId.serial, null, spenderAccountId);
    }

    @Deprecated
    public AccountAllowanceAdjustTransaction addAllTokenNftAllowance(TokenId tokenId, AccountId spenderAccountId) {
        return this.adjustNftAllowanceAllSerials(tokenId, true, null, spenderAccountId);
    }

    public AccountAllowanceAdjustTransaction grantTokenNftAllowance(NftId nftId, AccountId ownerAccountId, AccountId spenderAccountId) {
        Objects.requireNonNull(nftId);
        Objects.requireNonNull(ownerAccountId);
        return this.adjustNftAllowance(nftId.tokenId, nftId.serial, ownerAccountId, spenderAccountId);
    }

    public AccountAllowanceAdjustTransaction grantTokenNftAllowanceAllSerials(TokenId tokenId, AccountId ownerAccountId, AccountId spenderAccountId) {
        Objects.requireNonNull(ownerAccountId);
        return this.adjustNftAllowanceAllSerials(tokenId, true, ownerAccountId, spenderAccountId);
    }

    public AccountAllowanceAdjustTransaction revokeTokenNftAllowance(NftId nftId, AccountId ownerAccountId, AccountId spenderAccountId) {
        Objects.requireNonNull(nftId);
        Objects.requireNonNull(ownerAccountId);
        return this.adjustNftAllowance(nftId.tokenId, -nftId.serial, ownerAccountId, spenderAccountId);
    }

    public AccountAllowanceAdjustTransaction revokeTokenNftAllowanceAllSerials(TokenId tokenId, AccountId ownerAccountId, AccountId spenderAccountId) {
        Objects.requireNonNull(ownerAccountId);
        return this.adjustNftAllowanceAllSerials(tokenId, false, ownerAccountId, spenderAccountId);
    }

    public List<TokenNftAllowance> getTokenNftAllowances() {
        ArrayList<TokenNftAllowance> retval = new ArrayList<TokenNftAllowance>(this.nftAllowances.size());
        for (TokenNftAllowance allowance : this.nftAllowances) {
            retval.add(TokenNftAllowance.copyFrom(allowance));
        }
        return retval;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getAdjustAllowanceMethod();
    }

    CryptoAdjustAllowanceTransactionBody.Builder build() {
        CryptoAdjustAllowanceTransactionBody.Builder builder = CryptoAdjustAllowanceTransactionBody.newBuilder();
        AccountId ownerAccountId = this.transactionIds.size() > 0 && this.transactionIds.get(0) != null ? ((TransactionId)this.transactionIds.get((int)0)).accountId : null;
        for (HbarAllowance hbarAllowance : this.hbarAllowances) {
            builder.addCryptoAllowances(hbarAllowance.withOwner(ownerAccountId).toProtobuf());
        }
        for (TokenAllowance tokenAllowance : this.tokenAllowances) {
            builder.addTokenAllowances(tokenAllowance.withOwner(ownerAccountId).toProtobuf());
        }
        for (TokenNftAllowance tokenNftAllowance : this.nftAllowances) {
            builder.addNftAllowances(tokenNftAllowance.withOwner(ownerAccountId).toProtobuf());
        }
        return builder;
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setCryptoAdjustAllowance(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setCryptoAdjustAllowance(this.build());
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        for (HbarAllowance hbarAllowance : this.hbarAllowances) {
            if (hbarAllowance.spenderAccountId == null) continue;
            hbarAllowance.spenderAccountId.validateChecksum(client);
        }
        for (TokenAllowance tokenAllowance : this.tokenAllowances) {
            if (tokenAllowance.spenderAccountId != null) {
                tokenAllowance.spenderAccountId.validateChecksum(client);
            }
            if (tokenAllowance.tokenId == null) continue;
            tokenAllowance.tokenId.validateChecksum(client);
        }
        for (TokenNftAllowance tokenNftAllowance : this.nftAllowances) {
            if (tokenNftAllowance.spenderAccountId != null) {
                tokenNftAllowance.spenderAccountId.validateChecksum(client);
            }
            if (tokenNftAllowance.tokenId == null) continue;
            tokenNftAllowance.tokenId.validateChecksum(client);
        }
    }
}

