/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.HbarAllowance;
import com.hedera.hashgraph.sdk.NftId;
import com.hedera.hashgraph.sdk.TokenAllowance;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TokenNftAllowance;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.CryptoAllowance;
import com.hedera.hashgraph.sdk.proto.CryptoApproveAllowanceTransactionBody;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.NftAllowance;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class AccountAllowanceApproveTransaction
extends com.hedera.hashgraph.sdk.Transaction<AccountAllowanceApproveTransaction> {
    private final List<HbarAllowance> hbarAllowances = new ArrayList<HbarAllowance>();
    private final List<TokenAllowance> tokenAllowances = new ArrayList<TokenAllowance>();
    private final List<TokenNftAllowance> nftAllowances = new ArrayList<TokenNftAllowance>();
    private final Map<String, Map<TokenId, Integer>> nftMap = new HashMap<String, Map<TokenId, Integer>>();

    public AccountAllowanceApproveTransaction() {
    }

    AccountAllowanceApproveTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    AccountAllowanceApproveTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    private void initFromTransactionBody() {
        CryptoApproveAllowanceTransactionBody body = this.sourceTransactionBody.getCryptoApproveAllowance();
        for (CryptoAllowance cryptoAllowance : body.getCryptoAllowancesList()) {
            this.hbarAllowances.add(HbarAllowance.fromProtobuf(cryptoAllowance));
        }
        for (com.hedera.hashgraph.sdk.proto.TokenAllowance tokenAllowance : body.getTokenAllowancesList()) {
            this.tokenAllowances.add(TokenAllowance.fromProtobuf(tokenAllowance));
        }
        for (NftAllowance nftAllowance : body.getNftAllowancesList()) {
            if (nftAllowance.hasApprovedForAll() && nftAllowance.getApprovedForAll().getValue()) {
                this.nftAllowances.add(TokenNftAllowance.fromProtobuf(nftAllowance));
                continue;
            }
            this.getNftSerials(AccountId.fromProtobuf(nftAllowance.getOwner()), AccountId.fromProtobuf(nftAllowance.getSpender()), TokenId.fromProtobuf(nftAllowance.getTokenId())).addAll(nftAllowance.getSerialNumbersList());
        }
    }

    private AccountAllowanceApproveTransaction doApproveHbarAllowance(@Nullable AccountId ownerAccountId, AccountId spenderAccountId, Hbar amount) {
        this.requireNotFrozen();
        Objects.requireNonNull(amount);
        if (amount.compareTo(Hbar.ZERO) < 0) {
            throw new IllegalArgumentException("amount passed to approveHbarAllowance must be positive");
        }
        this.hbarAllowances.add(new HbarAllowance(ownerAccountId, Objects.requireNonNull(spenderAccountId), amount));
        return this;
    }

    @Deprecated
    public AccountAllowanceApproveTransaction addHbarAllowance(AccountId spenderAccountId, Hbar amount) {
        return this.doApproveHbarAllowance(null, spenderAccountId, amount);
    }

    public AccountAllowanceApproveTransaction approveHbarAllowance(AccountId ownerAccountId, AccountId spenderAccountId, Hbar amount) {
        return this.doApproveHbarAllowance(Objects.requireNonNull(ownerAccountId), spenderAccountId, amount);
    }

    @Deprecated
    public List<HbarAllowance> getHbarAllowances() {
        return this.getHbarApprovals();
    }

    public List<HbarAllowance> getHbarApprovals() {
        return new ArrayList<HbarAllowance>(this.hbarAllowances);
    }

    private AccountAllowanceApproveTransaction doApproveTokenAllowance(TokenId tokenId, @Nullable AccountId ownerAccountId, AccountId spenderAccountId, long amount) {
        this.requireNotFrozen();
        if (amount < 0L) {
            throw new IllegalArgumentException("amount given to approveTokenAllowance must be positive");
        }
        this.tokenAllowances.add(new TokenAllowance(Objects.requireNonNull(tokenId), ownerAccountId, Objects.requireNonNull(spenderAccountId), amount));
        return this;
    }

    @Deprecated
    public AccountAllowanceApproveTransaction addTokenAllowance(TokenId tokenId, AccountId spenderAccountId, long amount) {
        return this.doApproveTokenAllowance(tokenId, null, spenderAccountId, amount);
    }

    public AccountAllowanceApproveTransaction approveTokenAllowance(TokenId tokenId, AccountId ownerAccountId, AccountId spenderAccountId, long amount) {
        return this.doApproveTokenAllowance(tokenId, Objects.requireNonNull(ownerAccountId), spenderAccountId, amount);
    }

    @Deprecated
    public List<TokenAllowance> getTokenAllowances() {
        return this.getTokenApprovals();
    }

    public List<TokenAllowance> getTokenApprovals() {
        return new ArrayList<TokenAllowance>(this.tokenAllowances);
    }

    private static String ownerToString(@Nullable AccountId ownerAccountId) {
        return ownerAccountId != null ? ownerAccountId.toString() : "FEE_PAYER";
    }

    private List<Long> getNftSerials(@Nullable AccountId ownerAccountId, AccountId spenderAccountId, TokenId tokenId) {
        String key = AccountAllowanceApproveTransaction.ownerToString(ownerAccountId) + ":" + spenderAccountId;
        if (this.nftMap.containsKey(key)) {
            Map<TokenId, Integer> innerMap = this.nftMap.get(key);
            if (innerMap.containsKey(tokenId)) {
                return Objects.requireNonNull(this.nftAllowances.get((int)innerMap.get((Object)tokenId).intValue()).serialNumbers);
            }
            return this.newNftSerials(ownerAccountId, spenderAccountId, tokenId, innerMap);
        }
        HashMap<TokenId, Integer> innerMap = new HashMap<TokenId, Integer>();
        this.nftMap.put(key, innerMap);
        return this.newNftSerials(ownerAccountId, spenderAccountId, tokenId, innerMap);
    }

    private List<Long> newNftSerials(@Nullable AccountId ownerAccountId, AccountId spenderAccountId, TokenId tokenId, Map<TokenId, Integer> innerMap) {
        innerMap.put(tokenId, this.nftAllowances.size());
        TokenNftAllowance newAllowance = new TokenNftAllowance(tokenId, ownerAccountId, spenderAccountId, new ArrayList<Long>(), null);
        this.nftAllowances.add(newAllowance);
        return newAllowance.serialNumbers;
    }

    @Deprecated
    public AccountAllowanceApproveTransaction addTokenNftAllowance(NftId nftId, AccountId spenderAccountId) {
        this.requireNotFrozen();
        this.getNftSerials(null, spenderAccountId, nftId.tokenId).add(nftId.serial);
        return this;
    }

    @Deprecated
    public AccountAllowanceApproveTransaction addAllTokenNftAllowance(TokenId tokenId, AccountId spenderAccountId) {
        this.requireNotFrozen();
        this.nftAllowances.add(new TokenNftAllowance(tokenId, null, spenderAccountId, Collections.emptyList(), true));
        return this;
    }

    public AccountAllowanceApproveTransaction approveTokenNftAllowance(NftId nftId, AccountId ownerAccountId, AccountId spenderAccountId) {
        this.requireNotFrozen();
        Objects.requireNonNull(nftId);
        this.getNftSerials(Objects.requireNonNull(ownerAccountId), Objects.requireNonNull(spenderAccountId), nftId.tokenId).add(nftId.serial);
        return this;
    }

    public AccountAllowanceApproveTransaction approveTokenNftAllowanceAllSerials(TokenId tokenId, AccountId ownerAccountId, AccountId spenderAccountId) {
        this.requireNotFrozen();
        this.nftAllowances.add(new TokenNftAllowance(Objects.requireNonNull(tokenId), Objects.requireNonNull(ownerAccountId), Objects.requireNonNull(spenderAccountId), Collections.emptyList(), true));
        return this;
    }

    @Deprecated
    public List<TokenNftAllowance> getTokenNftAllowances() {
        return this.getTokenNftApprovals();
    }

    public List<TokenNftAllowance> getTokenNftApprovals() {
        ArrayList<TokenNftAllowance> retval = new ArrayList<TokenNftAllowance>(this.nftAllowances.size());
        for (TokenNftAllowance allowance : this.nftAllowances) {
            retval.add(TokenNftAllowance.copyFrom(allowance));
        }
        return retval;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getApproveAllowancesMethod();
    }

    CryptoApproveAllowanceTransactionBody.Builder build() {
        CryptoApproveAllowanceTransactionBody.Builder builder = CryptoApproveAllowanceTransactionBody.newBuilder();
        AccountId ownerAccountId = this.transactionIds.size() > 0 && this.transactionIds.get(0) != null ? ((TransactionId)this.transactionIds.get((int)0)).accountId : null;
        for (HbarAllowance hbarAllowance : this.hbarAllowances) {
            builder.addCryptoAllowances(hbarAllowance.withOwner(ownerAccountId).toProtobuf());
        }
        for (TokenAllowance tokenAllowance : this.tokenAllowances) {
            builder.addTokenAllowances(tokenAllowance.withOwner(ownerAccountId).toProtobuf());
        }
        for (TokenNftAllowance tokenNftAllowance : this.nftAllowances) {
            builder.addNftAllowances(tokenNftAllowance.withOwner(ownerAccountId).toProtobuf());
        }
        return builder;
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setCryptoApproveAllowance(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setCryptoApproveAllowance(this.build());
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        for (HbarAllowance hbarAllowance : this.hbarAllowances) {
            if (hbarAllowance.spenderAccountId == null) continue;
            hbarAllowance.spenderAccountId.validateChecksum(client);
        }
        for (TokenAllowance tokenAllowance : this.tokenAllowances) {
            if (tokenAllowance.spenderAccountId != null) {
                tokenAllowance.spenderAccountId.validateChecksum(client);
            }
            if (tokenAllowance.tokenId == null) continue;
            tokenAllowance.tokenId.validateChecksum(client);
        }
        for (TokenNftAllowance tokenNftAllowance : this.nftAllowances) {
            if (tokenNftAllowance.spenderAccountId != null) {
                tokenNftAllowance.spenderAccountId.validateChecksum(client);
            }
            if (tokenNftAllowance.tokenId == null) continue;
            tokenNftAllowance.tokenId.validateChecksum(client);
        }
    }
}

