/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.CustomFee;
import com.hedera.hashgraph.sdk.FeeAssessmentMethod;
import com.hedera.hashgraph.sdk.proto.CustomFee;
import com.hedera.hashgraph.sdk.proto.Fraction;
import com.hedera.hashgraph.sdk.proto.FractionalFee;
import java.util.Objects;

public class CustomFractionalFee
extends CustomFee {
    private long numerator = 0L;
    private long denominator = 1L;
    private long min = 0L;
    private long max = 0L;
    private FeeAssessmentMethod assessmentMethod = FeeAssessmentMethod.INCLUSIVE;

    static CustomFractionalFee clonedFrom(CustomFractionalFee source) {
        CustomFractionalFee returnFee = new CustomFractionalFee();
        returnFee.numerator = source.numerator;
        returnFee.denominator = source.denominator;
        returnFee.min = source.min;
        returnFee.max = source.max;
        returnFee.assessmentMethod = source.assessmentMethod;
        returnFee.feeCollectorAccountId = source.feeCollectorAccountId;
        return returnFee;
    }

    static CustomFractionalFee fromProtobuf(FractionalFee fractionalFee) {
        Fraction fraction = fractionalFee.getFractionalAmount();
        return new CustomFractionalFee().setNumerator(fraction.getNumerator()).setDenominator(fraction.getDenominator()).setMin(fractionalFee.getMinimumAmount()).setMax(fractionalFee.getMaximumAmount()).setAssessmentMethod(FeeAssessmentMethod.valueOf(fractionalFee.getNetOfTransfers()));
    }

    static CustomFractionalFee fromProtobuf(com.hedera.hashgraph.sdk.proto.CustomFee customFee) {
        CustomFractionalFee returnFee = CustomFractionalFee.fromProtobuf(customFee.getFractionalFee());
        if (customFee.hasFeeCollectorAccountId()) {
            returnFee.setFeeCollectorAccountId(AccountId.fromProtobuf(customFee.getFeeCollectorAccountId()));
        }
        return returnFee;
    }

    public CustomFractionalFee setFeeCollectorAccountId(AccountId feeCollectorAccountId) {
        this.doSetFeeCollectorAccountId(feeCollectorAccountId);
        return this;
    }

    public long getNumerator() {
        return this.numerator;
    }

    public CustomFractionalFee setNumerator(long numerator) {
        this.numerator = numerator;
        return this;
    }

    public long getDenominator() {
        return this.denominator;
    }

    public CustomFractionalFee setDenominator(long denominator) {
        this.denominator = denominator;
        return this;
    }

    public long getMin() {
        return this.min;
    }

    public CustomFractionalFee setMin(long min) {
        this.min = min;
        return this;
    }

    public long getMax() {
        return this.max;
    }

    public CustomFractionalFee setMax(long max) {
        this.max = max;
        return this;
    }

    public FeeAssessmentMethod getAssessmentMethod() {
        return this.assessmentMethod;
    }

    public CustomFractionalFee setAssessmentMethod(FeeAssessmentMethod assessmentMethod) {
        Objects.requireNonNull(assessmentMethod);
        this.assessmentMethod = assessmentMethod;
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("feeCollectorAccountId", (Object)this.getFeeCollectorAccountId()).add("numerator", this.getNumerator()).add("denominator", this.getDenominator()).add("min", this.getMin()).add("max", this.getMax()).add("assessmentMethod", (Object)this.getAssessmentMethod()).toString();
    }

    FractionalFee toFractionalFeeProtobuf() {
        return (FractionalFee)FractionalFee.newBuilder().setMinimumAmount(this.getMin()).setMaximumAmount(this.getMax()).setFractionalAmount(Fraction.newBuilder().setNumerator(this.getNumerator()).setDenominator(this.getDenominator())).setNetOfTransfers(this.assessmentMethod.code).build();
    }

    @Override
    com.hedera.hashgraph.sdk.proto.CustomFee toProtobuf() {
        CustomFee.Builder customFeeBuilder = com.hedera.hashgraph.sdk.proto.CustomFee.newBuilder().setFractionalFee(this.toFractionalFeeProtobuf());
        return this.finishToProtobuf(customFeeBuilder);
    }
}

