/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.Crypto;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.proto.SignaturePair;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.ECDSASigner;

public class PublicKeyECDSA
extends PublicKey {
    private byte[] keyData;

    PublicKeyECDSA(byte[] keyData) {
        this.keyData = keyData;
    }

    static PublicKeyECDSA fromBytesInternal(byte[] publicKey) {
        if (publicKey.length == 33) {
            return new PublicKeyECDSA(publicKey);
        }
        if (publicKey.length == 65) {
            return new PublicKeyECDSA(Key.ECDSA_SECP256K1_CURVE.getCurve().decodePoint(publicKey).getEncoded(true));
        }
        return PublicKeyECDSA.fromSubjectKeyInfoInternal(SubjectPublicKeyInfo.getInstance((Object)publicKey));
    }

    static PublicKeyECDSA fromSubjectKeyInfoInternal(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return new PublicKeyECDSA(subjectPublicKeyInfo.getPublicKeyData().getBytes());
    }

    @Override
    ByteString extractSignatureFromProtobuf(SignaturePair pair) {
        return pair.getECDSA384();
    }

    @Override
    public boolean verify(byte[] message, byte[] signature) {
        byte[] hash = Crypto.calcKeccak256(message);
        ECDSASigner signer = new ECDSASigner();
        signer.init(false, (CipherParameters)new ECPublicKeyParameters(Key.ECDSA_SECP256K1_CURVE.getCurve().decodePoint(this.keyData), Key.ECDSA_SECP256K1_DOMAIN));
        BigInteger r = new BigInteger(1, Arrays.copyOf(signature, 32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(signature, 32, 64));
        return signer.verifySignature(hash, r, s);
    }

    @Override
    com.hedera.hashgraph.sdk.proto.Key toProtobufKey() {
        return (com.hedera.hashgraph.sdk.proto.Key)com.hedera.hashgraph.sdk.proto.Key.newBuilder().setECDSASecp256K1(ByteString.copyFrom((byte[])this.keyData)).build();
    }

    @Override
    SignaturePair toSignaturePairProtobuf(byte[] signature) {
        return (SignaturePair)SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFrom((byte[])this.keyData)).setECDSASecp256K1(ByteString.copyFrom((byte[])signature)).build();
    }

    @Override
    public byte[] toBytesDER() {
        try {
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(ID_ECDSA_SECP256K1), this.keyData).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] toBytes() {
        return this.toBytesDER();
    }

    @Override
    public byte[] toBytesRaw() {
        return this.keyData;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyECDSA publicKey = (PublicKeyECDSA)o;
        return Arrays.equals(this.keyData, publicKey.keyData);
    }

    public int hashCode() {
        return Arrays.hashCode(this.keyData);
    }

    @Override
    public boolean isED25519() {
        return false;
    }

    @Override
    public boolean isECDSA() {
        return true;
    }
}

