/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.proto.StorageChange;
import java.math.BigInteger;
import javax.annotation.Nullable;

public class StorageChange {
    public final BigInteger slot;
    public final BigInteger valueRead;
    @Nullable
    public final BigInteger valueWritten;

    StorageChange(BigInteger slot, BigInteger valueRead, @Nullable BigInteger valueWritten) {
        this.slot = slot;
        this.valueRead = valueRead;
        this.valueWritten = valueWritten;
    }

    static StorageChange fromProtobuf(com.hedera.hashgraph.sdk.proto.StorageChange storageChangeProto) {
        return new StorageChange(new BigInteger(storageChangeProto.getSlot().toByteArray()), new BigInteger(storageChangeProto.getValueRead().toByteArray()), storageChangeProto.hasValueWritten() ? (storageChangeProto.getValueWritten().getValue().size() == 0 ? BigInteger.ZERO : new BigInteger(storageChangeProto.getValueWritten().getValue().toByteArray())) : null);
    }

    public static StorageChange fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return StorageChange.fromProtobuf(com.hedera.hashgraph.sdk.proto.StorageChange.parseFrom(bytes));
    }

    com.hedera.hashgraph.sdk.proto.StorageChange toProtobuf() {
        StorageChange.Builder builder = com.hedera.hashgraph.sdk.proto.StorageChange.newBuilder().setSlot(ByteString.copyFrom((byte[])this.slot.toByteArray())).setValueRead(ByteString.copyFrom((byte[])this.valueRead.toByteArray()));
        if (this.valueWritten != null) {
            if (this.valueWritten.equals(BigInteger.ZERO)) {
                builder.setValueWritten((BytesValue)BytesValue.newBuilder().setValue(ByteString.EMPTY).build());
            } else {
                builder.setValueWritten((BytesValue)BytesValue.newBuilder().setValue(ByteString.copyFrom((byte[])this.valueWritten.toByteArray())).build());
            }
        }
        return (com.hedera.hashgraph.sdk.proto.StorageChange)builder.build();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

