/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.proto.GrantedTokenAllowance;
import com.hedera.hashgraph.sdk.proto.TokenAllowance;
import java.util.Objects;
import javax.annotation.Nullable;

public class TokenAllowance {
    @Nullable
    public final TokenId tokenId;
    @Nullable
    public final AccountId ownerAccountId;
    @Nullable
    public final AccountId spenderAccountId;
    public final long amount;

    TokenAllowance(@Nullable TokenId tokenId, @Nullable AccountId ownerAccountId, @Nullable AccountId spenderAccountId, long amount) {
        this.tokenId = tokenId;
        this.ownerAccountId = ownerAccountId;
        this.spenderAccountId = spenderAccountId;
        this.amount = amount;
    }

    static TokenAllowance fromProtobuf(com.hedera.hashgraph.sdk.proto.TokenAllowance allowanceProto) {
        return new TokenAllowance(allowanceProto.hasTokenId() ? TokenId.fromProtobuf(allowanceProto.getTokenId()) : null, allowanceProto.hasOwner() ? AccountId.fromProtobuf(allowanceProto.getOwner()) : null, allowanceProto.hasSpender() ? AccountId.fromProtobuf(allowanceProto.getSpender()) : null, allowanceProto.getAmount());
    }

    static TokenAllowance fromProtobuf(GrantedTokenAllowance allowanceProto) {
        return new TokenAllowance(allowanceProto.hasTokenId() ? TokenId.fromProtobuf(allowanceProto.getTokenId()) : null, null, allowanceProto.hasSpender() ? AccountId.fromProtobuf(allowanceProto.getSpender()) : null, allowanceProto.getAmount());
    }

    public static TokenAllowance fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TokenAllowance.fromProtobuf(com.hedera.hashgraph.sdk.proto.TokenAllowance.parseFrom(Objects.requireNonNull(bytes)));
    }

    TokenAllowance withOwner(@Nullable AccountId newOwnerAccountId) {
        return this.ownerAccountId != null ? this : new TokenAllowance(this.tokenId, newOwnerAccountId, this.spenderAccountId, this.amount);
    }

    com.hedera.hashgraph.sdk.proto.TokenAllowance toProtobuf() {
        TokenAllowance.Builder builder = com.hedera.hashgraph.sdk.proto.TokenAllowance.newBuilder().setAmount(this.amount);
        if (this.tokenId != null) {
            builder.setTokenId(this.tokenId.toProtobuf());
        }
        if (this.ownerAccountId != null) {
            builder.setOwner(this.ownerAccountId.toProtobuf());
        }
        if (this.spenderAccountId != null) {
            builder.setSpender(this.spenderAccountId.toProtobuf());
        }
        return (com.hedera.hashgraph.sdk.proto.TokenAllowance)builder.build();
    }

    GrantedTokenAllowance toGrantedProtobuf() {
        GrantedTokenAllowance.Builder builder = GrantedTokenAllowance.newBuilder().setAmount(this.amount);
        if (this.tokenId != null) {
            builder.setTokenId(this.tokenId.toProtobuf());
        }
        if (this.spenderAccountId != null) {
            builder.setSpender(this.spenderAccountId.toProtobuf());
        }
        return (GrantedTokenAllowance)builder.build();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tokenId", (Object)this.tokenId).add("ownerAccountId", (Object)this.ownerAccountId).add("spenderAccountId", (Object)this.spenderAccountId).add("amount", this.amount).toString();
    }
}

