/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TokenSupplyType;
import com.hedera.hashgraph.sdk.TokenType;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.CustomFee;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenCreateTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public class TokenCreateTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenCreateTransaction> {
    private List<com.hedera.hashgraph.sdk.CustomFee> customFees = new ArrayList<com.hedera.hashgraph.sdk.CustomFee>();
    @Nullable
    private AccountId treasuryAccountId = null;
    @Nullable
    private AccountId autoRenewAccountId = null;
    private String tokenName = "";
    private String tokenSymbol = "";
    private int decimals = 0;
    private long initialSupply = 0L;
    @Nullable
    private Key adminKey = null;
    @Nullable
    private Key kycKey = null;
    @Nullable
    private Key freezeKey = null;
    @Nullable
    private Key wipeKey = null;
    @Nullable
    private Key supplyKey = null;
    @Nullable
    private Key feeScheduleKey = null;
    @Nullable
    private Key pauseKey = null;
    private boolean freezeDefault = false;
    @Nullable
    private Instant expirationTime = null;
    @Nullable
    private Duration autoRenewPeriod = null;
    private String tokenMemo = "";
    private TokenType tokenType = TokenType.FUNGIBLE_COMMON;
    private TokenSupplyType tokenSupplyType = TokenSupplyType.INFINITE;
    private long maxSupply = 0L;

    public TokenCreateTransaction() {
        this.setAutoRenewPeriod(DEFAULT_AUTO_RENEW_PERIOD);
        this.defaultMaxTransactionFee = new Hbar(30L);
    }

    TokenCreateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TokenCreateTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public String getTokenName() {
        return this.tokenName;
    }

    public TokenCreateTransaction setTokenName(String name) {
        Objects.requireNonNull(name);
        this.requireNotFrozen();
        this.tokenName = name;
        return this;
    }

    public String getTokenSymbol() {
        return this.tokenSymbol;
    }

    public TokenCreateTransaction setTokenSymbol(String symbol) {
        Objects.requireNonNull(symbol);
        this.requireNotFrozen();
        this.tokenSymbol = symbol;
        return this;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public TokenCreateTransaction setDecimals(@Nonnegative int decimals) {
        this.requireNotFrozen();
        this.decimals = decimals;
        return this;
    }

    public long getInitialSupply() {
        return this.initialSupply;
    }

    public TokenCreateTransaction setInitialSupply(@Nonnegative long initialSupply) {
        this.requireNotFrozen();
        this.initialSupply = initialSupply;
        return this;
    }

    @Nullable
    public AccountId getTreasuryAccountId() {
        return this.treasuryAccountId;
    }

    public TokenCreateTransaction setTreasuryAccountId(AccountId accountId) {
        Objects.requireNonNull(accountId);
        this.requireNotFrozen();
        this.treasuryAccountId = accountId;
        return this;
    }

    @Nullable
    public Key getAdminKey() {
        return this.adminKey;
    }

    public TokenCreateTransaction setAdminKey(Key key) {
        this.requireNotFrozen();
        Objects.requireNonNull(key);
        this.adminKey = key;
        return this;
    }

    @Nullable
    public Key getKycKey() {
        return this.kycKey;
    }

    public TokenCreateTransaction setKycKey(Key key) {
        this.requireNotFrozen();
        this.kycKey = key;
        return this;
    }

    @Nullable
    public Key getFreezeKey() {
        return this.freezeKey;
    }

    public TokenCreateTransaction setFreezeKey(Key key) {
        Objects.requireNonNull(key);
        this.requireNotFrozen();
        this.freezeKey = key;
        return this;
    }

    @Nullable
    public Key getWipeKey() {
        return this.wipeKey;
    }

    public TokenCreateTransaction setWipeKey(Key key) {
        Objects.requireNonNull(key);
        this.requireNotFrozen();
        this.wipeKey = key;
        return this;
    }

    @Nullable
    public Key getSupplyKey() {
        return this.supplyKey;
    }

    public TokenCreateTransaction setSupplyKey(Key key) {
        Objects.requireNonNull(key);
        this.requireNotFrozen();
        this.supplyKey = key;
        return this;
    }

    @Nullable
    public Key getFeeScheduleKey() {
        return this.feeScheduleKey;
    }

    public TokenCreateTransaction setFeeScheduleKey(Key key) {
        this.requireNotFrozen();
        Objects.requireNonNull(key);
        this.feeScheduleKey = key;
        return this;
    }

    @Nullable
    public Key getPauseKey() {
        return this.pauseKey;
    }

    public TokenCreateTransaction setPauseKey(Key key) {
        this.requireNotFrozen();
        Objects.requireNonNull(key);
        this.pauseKey = key;
        return this;
    }

    public boolean getFreezeDefault() {
        return this.freezeDefault;
    }

    public TokenCreateTransaction setFreezeDefault(boolean freezeDefault) {
        this.requireNotFrozen();
        this.freezeDefault = freezeDefault;
        return this;
    }

    @Nullable
    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    public TokenCreateTransaction setExpirationTime(Instant expirationTime) {
        Objects.requireNonNull(expirationTime);
        this.requireNotFrozen();
        this.autoRenewPeriod = null;
        this.expirationTime = expirationTime;
        return this;
    }

    @Nullable
    public AccountId getAutoRenewAccountId() {
        return this.autoRenewAccountId;
    }

    public TokenCreateTransaction setAutoRenewAccountId(AccountId accountId) {
        Objects.requireNonNull(accountId);
        this.requireNotFrozen();
        this.autoRenewAccountId = accountId;
        return this;
    }

    @Nullable
    public Duration getAutoRenewPeriod() {
        return this.autoRenewPeriod;
    }

    public TokenCreateTransaction setAutoRenewPeriod(Duration period) {
        Objects.requireNonNull(period);
        this.requireNotFrozen();
        this.autoRenewPeriod = period;
        return this;
    }

    public String getTokenMemo() {
        return this.tokenMemo;
    }

    public TokenCreateTransaction setTokenMemo(String memo) {
        Objects.requireNonNull(memo);
        this.requireNotFrozen();
        this.tokenMemo = memo;
        return this;
    }

    @Nullable
    public List<com.hedera.hashgraph.sdk.CustomFee> getCustomFees() {
        return com.hedera.hashgraph.sdk.CustomFee.deepCloneList(this.customFees);
    }

    public TokenCreateTransaction setCustomFees(List<com.hedera.hashgraph.sdk.CustomFee> customFees) {
        this.requireNotFrozen();
        this.customFees = com.hedera.hashgraph.sdk.CustomFee.deepCloneList(customFees);
        return this;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public TokenCreateTransaction setTokenType(TokenType tokenType) {
        this.requireNotFrozen();
        Objects.requireNonNull(tokenType);
        this.tokenType = tokenType;
        return this;
    }

    public TokenSupplyType getSupplyType() {
        return this.tokenSupplyType;
    }

    public TokenCreateTransaction setSupplyType(TokenSupplyType supplyType) {
        this.requireNotFrozen();
        Objects.requireNonNull(supplyType);
        this.tokenSupplyType = supplyType;
        return this;
    }

    public long getMaxSupply() {
        return this.maxSupply;
    }

    public TokenCreateTransaction setMaxSupply(@Nonnegative long maxSupply) {
        this.requireNotFrozen();
        this.maxSupply = maxSupply;
        return this;
    }

    @Override
    public TokenCreateTransaction freezeWith(@Nullable Client client) {
        if (this.autoRenewPeriod != null && this.autoRenewAccountId == null && client != null && client.getOperatorAccountId() != null) {
            this.autoRenewAccountId = client.getOperatorAccountId();
        }
        return (TokenCreateTransaction)super.freezeWith(client);
    }

    TokenCreateTransactionBody.Builder build() {
        TokenCreateTransactionBody.Builder builder = TokenCreateTransactionBody.newBuilder();
        if (this.treasuryAccountId != null) {
            builder.setTreasury(this.treasuryAccountId.toProtobuf());
        }
        if (this.autoRenewAccountId != null) {
            builder.setAutoRenewAccount(this.autoRenewAccountId.toProtobuf());
        }
        builder.setName(this.tokenName);
        builder.setSymbol(this.tokenSymbol);
        builder.setDecimals(this.decimals);
        builder.setInitialSupply(this.initialSupply);
        if (this.adminKey != null) {
            builder.setAdminKey(this.adminKey.toProtobufKey());
        }
        if (this.kycKey != null) {
            builder.setKycKey(this.kycKey.toProtobufKey());
        }
        if (this.freezeKey != null) {
            builder.setFreezeKey(this.freezeKey.toProtobufKey());
        }
        if (this.wipeKey != null) {
            builder.setWipeKey(this.wipeKey.toProtobufKey());
        }
        if (this.supplyKey != null) {
            builder.setSupplyKey(this.supplyKey.toProtobufKey());
        }
        if (this.feeScheduleKey != null) {
            builder.setFeeScheduleKey(this.feeScheduleKey.toProtobufKey());
        }
        if (this.pauseKey != null) {
            builder.setPauseKey(this.pauseKey.toProtobufKey());
        }
        builder.setFreezeDefault(this.freezeDefault);
        if (this.expirationTime != null) {
            builder.setExpiry(InstantConverter.toProtobuf(this.expirationTime));
        }
        if (this.autoRenewPeriod != null) {
            builder.setAutoRenewPeriod(DurationConverter.toProtobuf(this.autoRenewPeriod));
        }
        builder.setMemo(this.tokenMemo);
        builder.setTokenType(this.tokenType.code);
        builder.setSupplyType(this.tokenSupplyType.code);
        builder.setMaxSupply(this.maxSupply);
        for (com.hedera.hashgraph.sdk.CustomFee fee : this.customFees) {
            builder.addCustomFees(fee.toProtobuf());
        }
        return builder;
    }

    void initFromTransactionBody() {
        TokenCreateTransactionBody body = this.sourceTransactionBody.getTokenCreation();
        if (body.hasTreasury()) {
            this.treasuryAccountId = AccountId.fromProtobuf(body.getTreasury());
        }
        if (body.hasAutoRenewAccount()) {
            this.autoRenewAccountId = AccountId.fromProtobuf(body.getAutoRenewAccount());
        }
        this.tokenName = body.getName();
        this.tokenSymbol = body.getSymbol();
        this.decimals = body.getDecimals();
        this.initialSupply = body.getInitialSupply();
        if (body.hasAdminKey()) {
            this.adminKey = Key.fromProtobufKey(body.getAdminKey());
        }
        if (body.hasKycKey()) {
            this.kycKey = Key.fromProtobufKey(body.getKycKey());
        }
        if (body.hasFreezeKey()) {
            this.freezeKey = Key.fromProtobufKey(body.getFreezeKey());
        }
        if (body.hasWipeKey()) {
            this.wipeKey = Key.fromProtobufKey(body.getWipeKey());
        }
        if (body.hasSupplyKey()) {
            this.supplyKey = Key.fromProtobufKey(body.getSupplyKey());
        }
        if (body.hasFeeScheduleKey()) {
            this.feeScheduleKey = Key.fromProtobufKey(body.getFeeScheduleKey());
        }
        if (body.hasPauseKey()) {
            this.pauseKey = Key.fromProtobufKey(body.getPauseKey());
        }
        this.freezeDefault = body.getFreezeDefault();
        if (body.hasExpiry()) {
            this.expirationTime = InstantConverter.fromProtobuf(body.getExpiry());
        }
        if (body.hasAutoRenewPeriod()) {
            this.autoRenewPeriod = DurationConverter.fromProtobuf(body.getAutoRenewPeriod());
        }
        this.tokenMemo = body.getMemo();
        this.tokenType = TokenType.valueOf(body.getTokenType());
        this.tokenSupplyType = TokenSupplyType.valueOf(body.getSupplyType());
        this.maxSupply = body.getMaxSupply();
        for (CustomFee fee : body.getCustomFeesList()) {
            this.customFees.add(com.hedera.hashgraph.sdk.CustomFee.fromProtobuf(fee));
        }
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        for (com.hedera.hashgraph.sdk.CustomFee fee : this.customFees) {
            fee.validateChecksums(client);
        }
        if (this.treasuryAccountId != null) {
            this.treasuryAccountId.validateChecksum(client);
        }
        if (this.autoRenewAccountId != null) {
            this.autoRenewAccountId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getCreateTokenMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenCreation(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setTokenCreation(this.build());
    }
}

