/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.BoolValue;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.proto.GrantedNftAllowance;
import com.hedera.hashgraph.sdk.proto.NftAllowance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class TokenNftAllowance {
    @Nullable
    public final TokenId tokenId;
    @Nullable
    public final AccountId ownerAccountId;
    @Nullable
    public final AccountId spenderAccountId;
    public final List<Long> serialNumbers;
    @Nullable
    public final Boolean allSerials;

    TokenNftAllowance(@Nullable TokenId tokenId, @Nullable AccountId ownerAccountId, @Nullable AccountId spenderAccountId, Collection<Long> serialNumbers, @Nullable Boolean allSerials) {
        this.tokenId = tokenId;
        this.ownerAccountId = ownerAccountId;
        this.spenderAccountId = spenderAccountId;
        this.serialNumbers = new ArrayList<Long>(serialNumbers);
        this.allSerials = allSerials;
    }

    static TokenNftAllowance copyFrom(TokenNftAllowance allowance) {
        return new TokenNftAllowance(allowance.tokenId, allowance.ownerAccountId, allowance.spenderAccountId, allowance.serialNumbers, allowance.allSerials);
    }

    static TokenNftAllowance fromProtobuf(NftAllowance allowanceProto) {
        return new TokenNftAllowance(allowanceProto.hasTokenId() ? TokenId.fromProtobuf(allowanceProto.getTokenId()) : null, allowanceProto.hasOwner() ? AccountId.fromProtobuf(allowanceProto.getOwner()) : null, allowanceProto.hasSpender() ? AccountId.fromProtobuf(allowanceProto.getSpender()) : null, allowanceProto.getSerialNumbersList(), allowanceProto.hasApprovedForAll() ? Boolean.valueOf(allowanceProto.getApprovedForAll().getValue()) : null);
    }

    static TokenNftAllowance fromProtobuf(GrantedNftAllowance allowanceProto) {
        return new TokenNftAllowance(allowanceProto.hasTokenId() ? TokenId.fromProtobuf(allowanceProto.getTokenId()) : null, null, allowanceProto.hasSpender() ? AccountId.fromProtobuf(allowanceProto.getSpender()) : null, allowanceProto.getSerialNumbersList(), allowanceProto.getApprovedForAll());
    }

    public static TokenNftAllowance fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TokenNftAllowance.fromProtobuf(NftAllowance.parseFrom(Objects.requireNonNull(bytes)));
    }

    TokenNftAllowance withOwner(@Nullable AccountId newOwnerAccountId) {
        return this.ownerAccountId != null ? this : new TokenNftAllowance(this.tokenId, newOwnerAccountId, this.spenderAccountId, this.serialNumbers, this.allSerials);
    }

    NftAllowance toProtobuf() {
        NftAllowance.Builder builder = NftAllowance.newBuilder();
        if (this.tokenId != null) {
            builder.setTokenId(this.tokenId.toProtobuf());
        }
        if (this.ownerAccountId != null) {
            builder.setOwner(this.ownerAccountId.toProtobuf());
        }
        if (this.spenderAccountId != null) {
            builder.setSpender(this.spenderAccountId.toProtobuf());
        }
        builder.addAllSerialNumbers(this.serialNumbers);
        if (this.allSerials != null) {
            builder.setApprovedForAll((BoolValue)BoolValue.newBuilder().setValue(this.allSerials.booleanValue()).build());
        }
        return (NftAllowance)builder.build();
    }

    GrantedNftAllowance toGrantedProtobuf() {
        GrantedNftAllowance.Builder builder = GrantedNftAllowance.newBuilder();
        if (this.tokenId != null) {
            builder.setTokenId(this.tokenId.toProtobuf());
        }
        if (this.spenderAccountId != null) {
            builder.setSpender(this.spenderAccountId.toProtobuf());
        }
        builder.addAllSerialNumbers(this.serialNumbers);
        if (this.allSerials != null) {
            builder.setApprovedForAll(this.allSerials);
        }
        return (GrantedNftAllowance)builder.build();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this).add("tokenId", (Object)this.tokenId).add("ownerAccountId", (Object)this.ownerAccountId).add("spenderAccountId", (Object)this.spenderAccountId);
        if (this.allSerials != null) {
            stringHelper.add("allSerials", (Object)this.allSerials);
        } else {
            stringHelper.add("serials", this.serialNumbers);
        }
        return stringHelper.toString();
    }
}

