/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenPauseTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public class TokenPauseTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenPauseTransaction> {
    @Nullable
    private TokenId tokenId = null;

    public TokenPauseTransaction() {
    }

    TokenPauseTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TokenPauseTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public TokenId getTokenId() {
        return this.tokenId;
    }

    public TokenPauseTransaction setTokenId(TokenId tokenId) {
        Objects.requireNonNull(tokenId);
        this.requireNotFrozen();
        this.tokenId = tokenId;
        return this;
    }

    void initFromTransactionBody() {
        TokenPauseTransactionBody body = this.sourceTransactionBody.getTokenPause();
        if (body.hasToken()) {
            this.tokenId = TokenId.fromProtobuf(body.getToken());
        }
    }

    TokenPauseTransactionBody.Builder build() {
        TokenPauseTransactionBody.Builder builder = TokenPauseTransactionBody.newBuilder();
        if (this.tokenId != null) {
            builder.setToken(this.tokenId.toProtobuf());
        }
        return builder;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getPauseTokenMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenPause(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setTokenPause(this.build());
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.tokenId != null) {
            this.tokenId.validateChecksum(client);
        }
    }
}

