/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.TopicMessageChunk;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.mirror.ConsensusTopicResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nullable;

public final class TopicMessage {
    public final Instant consensusTimestamp;
    public final byte[] contents;
    public final byte[] runningHash;
    public final long sequenceNumber;
    @Nullable
    public final TopicMessageChunk[] chunks;
    @Nullable
    public final TransactionId transactionId;

    TopicMessage(Instant lastConsensusTimestamp, byte[] message, byte[] lastRunningHash, long lastSequenceNumber, @Nullable TopicMessageChunk[] chunks, @Nullable TransactionId transactionId) {
        this.consensusTimestamp = lastConsensusTimestamp;
        this.contents = message;
        this.runningHash = lastRunningHash;
        this.sequenceNumber = lastSequenceNumber;
        this.chunks = chunks;
        this.transactionId = transactionId;
    }

    static TopicMessage ofSingle(ConsensusTopicResponse response) {
        return new TopicMessage(InstantConverter.fromProtobuf(response.getConsensusTimestamp()), response.getMessage().toByteArray(), response.getRunningHash().toByteArray(), response.getSequenceNumber(), new TopicMessageChunk[]{new TopicMessageChunk(response)}, response.hasChunkInfo() && response.getChunkInfo().hasInitialTransactionID() ? TransactionId.fromProtobuf(response.getChunkInfo().getInitialTransactionID()) : null);
    }

    static TopicMessage ofMany(List<ConsensusTopicResponse> responses) {
        TopicMessageChunk[] chunks = new TopicMessageChunk[responses.size()];
        TransactionId transactionId = null;
        ByteString[] contents = new ByteString[responses.size()];
        long totalSize = 0L;
        for (ConsensusTopicResponse consensusTopicResponse : responses) {
            if (transactionId == null && consensusTopicResponse.getChunkInfo().hasInitialTransactionID()) {
                transactionId = TransactionId.fromProtobuf(consensusTopicResponse.getChunkInfo().getInitialTransactionID());
            }
            int index = consensusTopicResponse.getChunkInfo().getNumber() - 1;
            chunks[index] = new TopicMessageChunk(consensusTopicResponse);
            contents[index] = consensusTopicResponse.getMessage();
            totalSize += (long)consensusTopicResponse.getMessage().size();
        }
        ByteBuffer wholeMessage = ByteBuffer.allocate((int)totalSize);
        for (ByteString content : contents) {
            wholeMessage.put(content.asReadOnlyByteBuffer());
        }
        ConsensusTopicResponse consensusTopicResponse = responses.get(responses.size() - 1);
        return new TopicMessage(InstantConverter.fromProtobuf(consensusTopicResponse.getConsensusTimestamp()), wholeMessage.array(), consensusTopicResponse.getRunningHash().toByteArray(), consensusTopicResponse.getSequenceNumber(), chunks, transactionId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("consensusTimestamp", (Object)this.consensusTimestamp).add("contents", (Object)new String(this.contents, StandardCharsets.UTF_8)).add("runningHash", (Object)this.runningHash).add("sequenceNumber", this.sequenceNumber).toString();
    }
}

