/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.ChunkedTransaction;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TopicId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ConsensusMessageChunkInfo;
import com.hedera.hashgraph.sdk.proto.ConsensusServiceGrpc;
import com.hedera.hashgraph.sdk.proto.ConsensusSubmitMessageTransactionBody;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.SignedTransaction;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionID;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TopicMessageSubmitTransaction
extends ChunkedTransaction<TopicMessageSubmitTransaction> {
    @Nullable
    private TopicId topicId = null;

    public TopicMessageSubmitTransaction() {
    }

    TopicMessageSubmitTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TopicMessageSubmitTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public TopicId getTopicId() {
        return this.topicId;
    }

    public TopicMessageSubmitTransaction setTopicId(TopicId topicId) {
        Objects.requireNonNull(topicId);
        this.requireNotFrozen();
        this.topicId = topicId;
        return this;
    }

    public ByteString getMessage() {
        return this.getData();
    }

    public TopicMessageSubmitTransaction setMessage(ByteString message) {
        return (TopicMessageSubmitTransaction)this.setData(message);
    }

    public TopicMessageSubmitTransaction setMessage(byte[] message) {
        return (TopicMessageSubmitTransaction)this.setData(message);
    }

    public TopicMessageSubmitTransaction setMessage(String message) {
        return (TopicMessageSubmitTransaction)this.setData(message);
    }

    void initFromTransactionBody() {
        ConsensusSubmitMessageTransactionBody body = this.sourceTransactionBody.getConsensusSubmitMessage();
        if (body.hasTopicID()) {
            this.topicId = TopicId.fromProtobuf(body.getTopicID());
        }
        try {
            for (int i = 0; i < this.innerSignedTransactions.size(); i += this.nodeAccountIds.isEmpty() ? 1 : this.nodeAccountIds.size()) {
                this.data = this.data.concat(TransactionBody.parseFrom(((SignedTransaction.Builder)this.innerSignedTransactions.get(i)).getBodyBytes()).getConsensusSubmitMessage().getMessage());
            }
        }
        catch (InvalidProtocolBufferException exc) {
            throw new IllegalArgumentException(exc.getMessage());
        }
    }

    ConsensusSubmitMessageTransactionBody.Builder build() {
        ConsensusSubmitMessageTransactionBody.Builder builder = ConsensusSubmitMessageTransactionBody.newBuilder();
        if (this.topicId != null) {
            builder.setTopicID(this.topicId.toProtobuf());
        }
        builder.setMessage(this.data);
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.topicId != null) {
            this.topicId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return ConsensusServiceGrpc.getSubmitMessageMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setConsensusSubmitMessage(this.build());
    }

    @Override
    void onFreezeChunk(TransactionBody.Builder body, @Nullable TransactionID initialTransactionId, int startIndex, int endIndex, int chunk, int total) {
        if (total == 1) {
            body.setConsensusSubmitMessage(this.build().setMessage(this.data.substring(startIndex, endIndex)));
        } else {
            body.setConsensusSubmitMessage(this.build().setMessage(this.data.substring(startIndex, endIndex)).setChunkInfo(ConsensusMessageChunkInfo.newBuilder().setInitialTransactionID(Objects.requireNonNull(initialTransactionId)).setNumber(chunk + 1).setTotal(total)));
        }
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setConsensusSubmitMessage(this.build().setMessage(this.data));
    }
}

