/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface WithGetCost {
    public CompletableFuture<Hbar> getCostAsync(Client var1);

    default public void getCostAsync(Client client, BiConsumer<Hbar, Throwable> callback) {
        this.getCostAsync(client, client.getRequestTimeout(), callback);
    }

    default public void getCostAsync(Client client, Duration timeout, BiConsumer<Hbar, Throwable> callback) {
        this.getCostAsync(client).orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).whenComplete((BiConsumer)callback);
    }

    default public void getCostAsync(Client client, Consumer<Hbar> onSuccess, Consumer<Throwable> onFailure) {
        this.getCostAsync(client, client.getRequestTimeout(), onSuccess, onFailure);
    }

    default public void getCostAsync(Client client, Duration timeout, Consumer<Hbar> onSuccess, Consumer<Throwable> onFailure) {
        this.getCostAsync(client).orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).whenComplete((output, error) -> {
            if (error != null) {
                onFailure.accept((Throwable)error);
            } else {
                onSuccess.accept((Hbar)output);
            }
        });
    }

    default public Hbar getCost(Client client) throws TimeoutException, PrecheckStatusException {
        return this.getCost(client, client.getRequestTimeout());
    }

    default public Hbar getCost(Client client, Duration timeout) throws TimeoutException, PrecheckStatusException {
        try {
            return this.getCostAsync(client).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new RuntimeException(e);
            }
            if (cause instanceof PrecheckStatusException) {
                throw (PrecheckStatusException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

