/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ContractFunctionParameters;
import com.hedera.hashgraph.sdk.ContractFunctionResult;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.Query;
import com.hedera.hashgraph.sdk.proto.ContractCallLocalQuery;
import com.hedera.hashgraph.sdk.proto.Query;
import com.hedera.hashgraph.sdk.proto.QueryHeader;
import com.hedera.hashgraph.sdk.proto.Response;
import com.hedera.hashgraph.sdk.proto.ResponseHeader;
import com.hedera.hashgraph.sdk.proto.SmartContractServiceGrpc;
import io.grpc.MethodDescriptor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public final class ContractCallQuery
extends Query<ContractFunctionResult, ContractCallQuery> {
    @Nullable
    private ContractId contractId = null;
    private long gas = 0L;
    private byte[] functionParameters = new byte[0];
    private long maxResultSize = 0L;
    @Nullable
    private AccountId senderAccountId = null;

    @Nullable
    public ContractId getContractId() {
        return this.contractId;
    }

    public ContractCallQuery setContractId(ContractId contractId) {
        Objects.requireNonNull(contractId);
        this.contractId = contractId;
        return this;
    }

    public long getGas() {
        return this.gas;
    }

    public ContractCallQuery setGas(long gas) {
        this.gas = gas;
        return this;
    }

    @Override
    public CompletableFuture<Hbar> getCostAsync(Client client) {
        return super.getCostAsync(client).thenApply(cost -> Hbar.fromTinybars((long)((double)cost.toTinybars() * 1.1)));
    }

    public ByteString getFunctionParameters() {
        return ByteString.copyFrom((byte[])this.functionParameters);
    }

    public ContractCallQuery setFunctionParameters(byte[] functionParameters) {
        this.functionParameters = functionParameters;
        return this;
    }

    public ContractCallQuery setFunction(String name) {
        return this.setFunction(name, new ContractFunctionParameters());
    }

    public ContractCallQuery setFunction(String name, ContractFunctionParameters params) {
        Objects.requireNonNull(params);
        this.setFunctionParameters(params.toBytes(name).toByteArray());
        return this;
    }

    @Deprecated
    public long getMaxResultSize() {
        return this.maxResultSize;
    }

    @Deprecated
    public ContractCallQuery setMaxResultSize(long size) {
        this.maxResultSize = size;
        return this;
    }

    @Nullable
    public AccountId getSenderAccountId() {
        return this.senderAccountId;
    }

    public ContractCallQuery setSenderAccountId(AccountId senderAccountId) {
        Objects.requireNonNull(senderAccountId);
        this.senderAccountId = senderAccountId;
        return this;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.contractId != null) {
            this.contractId.validateChecksum(client);
        }
    }

    @Override
    void onMakeRequest(Query.Builder queryBuilder, QueryHeader header) {
        ContractCallLocalQuery.Builder builder = ContractCallLocalQuery.newBuilder();
        if (this.contractId != null) {
            builder.setContractID(this.contractId.toProtobuf());
        }
        builder.setGas(this.gas);
        builder.setFunctionParameters(ByteString.copyFrom((byte[])this.functionParameters));
        if (this.senderAccountId != null) {
            builder.setSenderId(this.senderAccountId.toProtobuf());
        }
        queryBuilder.setContractCallLocal(builder.setHeader(header));
    }

    @Override
    ResponseHeader mapResponseHeader(Response response) {
        return response.getContractCallLocal().getHeader();
    }

    @Override
    QueryHeader mapRequestHeader(com.hedera.hashgraph.sdk.proto.Query request) {
        return request.getContractCallLocal().getHeader();
    }

    @Override
    ContractFunctionResult mapResponse(Response response, AccountId nodeId, com.hedera.hashgraph.sdk.proto.Query request) {
        return new ContractFunctionResult(response.getContractCallLocal().getFunctionResult());
    }

    @Override
    MethodDescriptor<com.hedera.hashgraph.sdk.proto.Query, Response> getMethodDescriptor() {
        return SmartContractServiceGrpc.getContractCallLocalMethodMethod();
    }
}

