/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ContractCreateTransaction;
import com.hedera.hashgraph.sdk.ContractFunctionParameters;
import com.hedera.hashgraph.sdk.FileAppendTransaction;
import com.hedera.hashgraph.sdk.FileCreateTransaction;
import com.hedera.hashgraph.sdk.FileDeleteTransaction;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.ReceiptStatusException;
import com.hedera.hashgraph.sdk.TransactionReceiptQuery;
import com.hedera.hashgraph.sdk.TransactionResponse;
import com.hedera.hashgraph.sdk.WithExecute;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public class ContractCreateFlow
implements WithExecute<TransactionResponse> {
    static final int FILE_CREATE_MAX_BYTES = 2048;
    private String bytecode = "";
    @Nullable
    private Key adminKey = null;
    private long gas = 0L;
    private Hbar initialBalance = Hbar.ZERO;
    @Nullable
    private AccountId proxyAccountId = null;
    private int maxAutomaticTokenAssociations = 0;
    @Nullable
    private Duration autoRenewPeriod = null;
    private byte[] constructorParameters = new byte[0];
    @Nullable
    private String contractMemo = null;
    @Nullable
    private List<AccountId> nodeAccountIds = null;
    private String createBytecode = "";
    private String appendBytecode = "";

    public String getBytecode() {
        return this.bytecode;
    }

    public ContractCreateFlow setBytecode(String bytecode) {
        Objects.requireNonNull(bytecode);
        this.bytecode = bytecode;
        return this;
    }

    public ContractCreateFlow setBytecode(byte[] bytecode) {
        Objects.requireNonNull(bytecode);
        this.bytecode = Hex.toHexString((byte[])bytecode);
        return this;
    }

    public ContractCreateFlow setBytecode(ByteString bytecode) {
        Objects.requireNonNull(bytecode);
        return this.setBytecode(bytecode.toByteArray());
    }

    @Nullable
    public Key getAdminKey() {
        return this.adminKey;
    }

    public ContractCreateFlow setAdminKey(Key adminKey) {
        Objects.requireNonNull(adminKey);
        this.adminKey = adminKey;
        return this;
    }

    public long getGas() {
        return this.gas;
    }

    public ContractCreateFlow setGas(long gas) {
        this.gas = gas;
        return this;
    }

    public Hbar getInitialBalance() {
        return this.initialBalance;
    }

    public ContractCreateFlow setInitialBalance(Hbar initialBalance) {
        Objects.requireNonNull(initialBalance);
        this.initialBalance = initialBalance;
        return this;
    }

    @Nullable
    public AccountId getProxyAccountId() {
        return this.proxyAccountId;
    }

    public ContractCreateFlow setProxyAccountId(AccountId proxyAccountId) {
        Objects.requireNonNull(proxyAccountId);
        this.proxyAccountId = proxyAccountId;
        return this;
    }

    public int getMaxAutomaticTokenAssociations() {
        return this.maxAutomaticTokenAssociations;
    }

    public ContractCreateFlow setMaxAutomaticTokenAssociations(int maxAutomaticTokenAssociations) {
        Objects.requireNonNull(this.proxyAccountId);
        this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
        return this;
    }

    @Nullable
    public Duration getAutoRenewPeriod() {
        return this.autoRenewPeriod;
    }

    public ContractCreateFlow setAutoRenewPeriod(Duration autoRenewPeriod) {
        Objects.requireNonNull(autoRenewPeriod);
        this.autoRenewPeriod = autoRenewPeriod;
        return this;
    }

    public ByteString getConstructorParameters() {
        return ByteString.copyFrom((byte[])this.constructorParameters);
    }

    public ContractCreateFlow setConstructorParameters(byte[] constructorParameters) {
        this.constructorParameters = constructorParameters;
        return this;
    }

    public ContractCreateFlow setConstructorParameters(ContractFunctionParameters constructorParameters) {
        Objects.requireNonNull(constructorParameters);
        return this.setConstructorParameters(constructorParameters.toBytes(null).toByteArray());
    }

    public String getContractMemo() {
        return this.contractMemo;
    }

    public ContractCreateFlow setContractMemo(String memo) {
        Objects.requireNonNull(memo);
        this.contractMemo = memo;
        return this;
    }

    @Nullable
    public List<AccountId> getNodeAccountIds() {
        return this.nodeAccountIds;
    }

    public ContractCreateFlow setNodeAccountIds(List<AccountId> nodeAccountIds) {
        Objects.requireNonNull(nodeAccountIds);
        this.nodeAccountIds = nodeAccountIds;
        return this;
    }

    private void splitBytecode() {
        if (this.bytecode.length() > 2048) {
            this.createBytecode = this.bytecode.substring(0, 2048);
            this.appendBytecode = this.bytecode.substring(2048);
        } else {
            this.createBytecode = this.bytecode;
            this.appendBytecode = "";
        }
    }

    private FileCreateTransaction createFileCreateTransaction(Client client) {
        FileCreateTransaction fileCreateTx = new FileCreateTransaction().setKeys(Objects.requireNonNull(client.getOperatorPublicKey())).setContents(this.createBytecode);
        if (this.nodeAccountIds != null) {
            fileCreateTx.setNodeAccountIds((List)this.nodeAccountIds);
        }
        return fileCreateTx;
    }

    private FileAppendTransaction createFileAppendTransaction(FileId fileId) {
        FileAppendTransaction fileAppendTx = new FileAppendTransaction().setFileId(fileId).setContents(this.appendBytecode);
        if (this.nodeAccountIds != null) {
            fileAppendTx.setNodeAccountIds((List)this.nodeAccountIds);
        }
        return fileAppendTx;
    }

    private ContractCreateTransaction createContractCreateTransaction(FileId fileId) {
        ContractCreateTransaction contractCreateTx = new ContractCreateTransaction().setBytecodeFileId(fileId).setConstructorParameters(this.constructorParameters).setGas(this.gas).setInitialBalance(this.initialBalance).setMaxAutomaticTokenAssociations(this.maxAutomaticTokenAssociations);
        if (this.adminKey != null) {
            contractCreateTx.setAdminKey(this.adminKey);
        }
        if (this.proxyAccountId != null) {
            contractCreateTx.setProxyAccountId(this.proxyAccountId);
        }
        if (this.autoRenewPeriod != null) {
            contractCreateTx.setAutoRenewPeriod(this.autoRenewPeriod);
        }
        if (this.contractMemo != null) {
            contractCreateTx.setContractMemo(this.contractMemo);
        }
        if (this.nodeAccountIds != null) {
            contractCreateTx.setNodeAccountIds((List)this.nodeAccountIds);
        }
        return contractCreateTx;
    }

    TransactionReceiptQuery createTransactionReceiptQuery(TransactionResponse response) {
        return ((TransactionReceiptQuery)new TransactionReceiptQuery().setNodeAccountIds((List)Collections.singletonList(response.nodeId))).setTransactionId(response.transactionId);
    }

    @Override
    public TransactionResponse execute(Client client) throws PrecheckStatusException, TimeoutException {
        try {
            this.splitBytecode();
            FileId fileId = ((TransactionResponse)this.createFileCreateTransaction((Client)client).execute((Client)client)).getReceipt((Client)client).fileId;
            Objects.requireNonNull(fileId);
            if (!this.appendBytecode.isEmpty()) {
                this.createFileAppendTransaction(fileId).execute(client);
            }
            TransactionResponse response = (TransactionResponse)this.createContractCreateTransaction(fileId).execute(client);
            response.getReceipt(client);
            new FileDeleteTransaction().setFileId(fileId).execute(client);
            return response;
        }
        catch (ReceiptStatusException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<TransactionResponse> executeAsync(Client client) {
        this.splitBytecode();
        return ((CompletableFuture)this.createFileCreateTransaction(client).executeAsync(client).thenCompose(fileCreateResponse -> this.createTransactionReceiptQuery((TransactionResponse)fileCreateResponse).executeAsync(client).thenApply(receipt -> receipt.fileId))).thenCompose(fileId -> {
            CompletableFuture<Object> appendFuture = this.appendBytecode.isEmpty() ? CompletableFuture.completedFuture(null) : this.createFileAppendTransaction((FileId)fileId).executeAsync(client).thenApply(ignored -> null);
            return appendFuture.thenCompose(ignored -> this.createContractCreateTransaction((FileId)fileId).executeAsync(client).thenApply(contractCreateResponse -> {
                contractCreateResponse.getReceiptAsync(client).thenRun(() -> new FileDeleteTransaction().setFileId((FileId)fileId).executeAsync(client));
                return contractCreateResponse;
            }));
        });
    }
}

