/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.errorprone.annotations.Var;
import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.ContractFunctionSelector;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

public final class ContractFunctionParameters {
    public static final int ADDRESS_LEN = 20;
    public static final int ADDRESS_LEN_HEX = 40;
    public static final int SELECTOR_LEN = 4;
    public static final int SELECTOR_LEN_HEX = 8;
    private static final ByteString padding = ByteString.copyFrom((byte[])new byte[31]);
    private static final ByteString negativePadding;
    private final ArrayList<Argument> args = new ArrayList();

    private static ByteString encodeString(String string) {
        ByteString strBytes = ByteString.copyFromUtf8((String)string);
        return ContractFunctionParameters.int256(strBytes.size(), 32).concat(ContractFunctionParameters.rightPad32(strBytes));
    }

    private static ByteString encodeBytes(byte[] bytes) {
        return ContractFunctionParameters.int256(bytes.length, 32).concat(ContractFunctionParameters.rightPad32(ByteString.copyFrom((byte[])bytes)));
    }

    private static ByteString encodeBytes32(byte[] bytes) {
        if (bytes.length > 32) {
            throw new IllegalArgumentException("byte32 encoding forbids byte array length greater than 32");
        }
        return ContractFunctionParameters.rightPad32(ByteString.copyFrom((byte[])bytes));
    }

    private static ByteString encodeArray(Stream<ByteString> elements) {
        List list = elements.collect(Collectors.toList());
        return ContractFunctionParameters.int256(list.size(), 32).concat(ByteString.copyFrom(list));
    }

    private static ByteString encodeDynArr(List<ByteString> elements) {
        int offsetsLen = elements.size();
        ArrayList<ByteString> head = new ArrayList<ByteString>(offsetsLen + 1);
        head.add(ContractFunctionParameters.uint256(elements.size(), 32));
        long currOffset = (long)offsetsLen * 32L;
        for (ByteString elem : elements) {
            head.add(ContractFunctionParameters.uint256(currOffset, 64));
            currOffset += (long)elem.size();
        }
        return ByteString.copyFrom(head).concat(ByteString.copyFrom(elements));
    }

    static ByteString int256(long val, int bitWidth) {
        return ContractFunctionParameters.int256(val, bitWidth, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ByteString int256(long val, @Var int bitWidth, boolean signed) {
        bitWidth = Math.min(bitWidth, 64);
        ByteString.Output output = ByteString.newOutput((int)(bitWidth / 8));
        try {
            for (int i = bitWidth - 8; i >= 0; i -= 8) {
                byte u8 = (byte)(val >> i);
                output.write((int)u8);
            }
            ByteString byteString = ContractFunctionParameters.leftPad32(output.toByteString(), signed && val < 0L);
            return byteString;
        }
        finally {
            try {
                output.close();
            }
            catch (Throwable throwable) {}
        }
    }

    static byte[] getTruncatedBytes(BigInteger bigInt, int bitWidth) {
        int expectedBytes;
        byte[] bytes = bigInt.toByteArray();
        return bytes.length <= (expectedBytes = bitWidth / 8) ? bytes : Arrays.copyOfRange(bytes, bytes.length - expectedBytes, bytes.length);
    }

    static ByteString int256(BigInteger bigInt, int bitWidth) {
        return ContractFunctionParameters.leftPad32(ContractFunctionParameters.getTruncatedBytes(bigInt, bitWidth), bigInt.signum() < 0);
    }

    static ByteString uint256(long val, int bitWidth) {
        return ContractFunctionParameters.int256(val, bitWidth, false);
    }

    static ByteString uint256(BigInteger bigInt, int bitWidth) {
        if (bigInt.signum() < 0) {
            throw new IllegalArgumentException("negative BigInteger passed to unsigned function");
        }
        return ContractFunctionParameters.leftPad32(ContractFunctionParameters.getTruncatedBytes(bigInt, bitWidth), false);
    }

    static ByteString leftPad32(ByteString input) {
        return ContractFunctionParameters.leftPad32(input, false);
    }

    static ByteString leftPad32(ByteString input, boolean negative) {
        int rem = 32 - input.size() % 32;
        return rem == 32 ? input : (negative ? negativePadding : padding).substring(0, rem).concat(input);
    }

    static ByteString leftPad32(byte[] input, boolean negative) {
        return ContractFunctionParameters.leftPad32(ByteString.copyFrom((byte[])input), negative);
    }

    static ByteString rightPad32(ByteString input) {
        int rem = 32 - input.size() % 32;
        return rem == 32 ? input : input.concat(padding.substring(0, rem));
    }

    private static byte[] decodeAddress(@Var String address) {
        String string = address = address.startsWith("0x") ? address.substring(2) : address;
        if (address.length() != 40) {
            throw new IllegalArgumentException("Solidity addresses must be 40 hex chars");
        }
        try {
            return Hex.decode((String)address);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("failed to decode Solidity address as hex", e);
        }
    }

    public ContractFunctionParameters addString(String param) {
        this.args.add(new Argument("string", ContractFunctionParameters.encodeString(param), true));
        return this;
    }

    public ContractFunctionParameters addStringArray(String[] strings) {
        List<ByteString> byteStrings = Arrays.stream(strings).map(ContractFunctionParameters::encodeString).collect(Collectors.toList());
        ByteString argBytes = ContractFunctionParameters.encodeDynArr(byteStrings);
        this.args.add(new Argument("string[]", argBytes, true));
        return this;
    }

    public ContractFunctionParameters addBytes(byte[] param) {
        this.args.add(new Argument("bytes", ContractFunctionParameters.encodeBytes(param), true));
        return this;
    }

    public ContractFunctionParameters addBytesArray(byte[][] param) {
        List<ByteString> byteArrays = Arrays.stream(param).map(ContractFunctionParameters::encodeBytes).collect(Collectors.toList());
        this.args.add(new Argument("bytes[]", ContractFunctionParameters.encodeDynArr(byteArrays), true));
        return this;
    }

    public ContractFunctionParameters addBytes32(byte[] param) {
        this.args.add(new Argument("bytes32", ContractFunctionParameters.encodeBytes32(param), false));
        return this;
    }

    public ContractFunctionParameters addBytes32Array(byte[][] param) {
        Stream<ByteString> byteArrays = Arrays.stream(param).map(ContractFunctionParameters::encodeBytes32);
        this.args.add(new Argument("bytes32[]", ContractFunctionParameters.encodeArray(byteArrays), true));
        return this;
    }

    public ContractFunctionParameters addBool(boolean bool) {
        this.args.add(new Argument("bool", ContractFunctionParameters.int256(bool ? 1L : 0L, 8), false));
        return this;
    }

    public ContractFunctionParameters addInt8(byte value) {
        this.args.add(new Argument("int8", ContractFunctionParameters.int256(value, 8), false));
        return this;
    }

    public ContractFunctionParameters addInt16(int value) {
        this.args.add(new Argument("int16", ContractFunctionParameters.int256(value, 16), false));
        return this;
    }

    public ContractFunctionParameters addInt24(int value) {
        this.args.add(new Argument("int24", ContractFunctionParameters.int256(value, 24), false));
        return this;
    }

    public ContractFunctionParameters addInt32(int value) {
        this.args.add(new Argument("int32", ContractFunctionParameters.int256(value, 32), false));
        return this;
    }

    public ContractFunctionParameters addInt40(long value) {
        this.args.add(new Argument("int40", ContractFunctionParameters.int256(value, 40), false));
        return this;
    }

    public ContractFunctionParameters addInt48(long value) {
        this.args.add(new Argument("int48", ContractFunctionParameters.int256(value, 48), false));
        return this;
    }

    public ContractFunctionParameters addInt56(long value) {
        this.args.add(new Argument("int56", ContractFunctionParameters.int256(value, 56), false));
        return this;
    }

    public ContractFunctionParameters addInt64(long value) {
        this.args.add(new Argument("int64", ContractFunctionParameters.int256(value, 64), false));
        return this;
    }

    public ContractFunctionParameters addInt72(BigInteger value) {
        this.args.add(new Argument("int72", ContractFunctionParameters.int256(value, 72), false));
        return this;
    }

    public ContractFunctionParameters addInt80(BigInteger value) {
        this.args.add(new Argument("int80", ContractFunctionParameters.int256(value, 80), false));
        return this;
    }

    public ContractFunctionParameters addInt88(BigInteger value) {
        this.args.add(new Argument("int88", ContractFunctionParameters.int256(value, 88), false));
        return this;
    }

    public ContractFunctionParameters addInt96(BigInteger value) {
        this.args.add(new Argument("int96", ContractFunctionParameters.int256(value, 96), false));
        return this;
    }

    public ContractFunctionParameters addInt104(BigInteger value) {
        this.args.add(new Argument("int104", ContractFunctionParameters.int256(value, 104), false));
        return this;
    }

    public ContractFunctionParameters addInt112(BigInteger value) {
        this.args.add(new Argument("int112", ContractFunctionParameters.int256(value, 112), false));
        return this;
    }

    public ContractFunctionParameters addInt120(BigInteger value) {
        this.args.add(new Argument("int120", ContractFunctionParameters.int256(value, 120), false));
        return this;
    }

    public ContractFunctionParameters addInt128(BigInteger value) {
        this.args.add(new Argument("int128", ContractFunctionParameters.int256(value, 128), false));
        return this;
    }

    public ContractFunctionParameters addInt136(BigInteger value) {
        this.args.add(new Argument("int136", ContractFunctionParameters.int256(value, 136), false));
        return this;
    }

    public ContractFunctionParameters addInt144(BigInteger value) {
        this.args.add(new Argument("int144", ContractFunctionParameters.int256(value, 144), false));
        return this;
    }

    public ContractFunctionParameters addInt152(BigInteger value) {
        this.args.add(new Argument("int152", ContractFunctionParameters.int256(value, 152), false));
        return this;
    }

    public ContractFunctionParameters addInt160(BigInteger value) {
        this.args.add(new Argument("int160", ContractFunctionParameters.int256(value, 160), false));
        return this;
    }

    public ContractFunctionParameters addInt168(BigInteger value) {
        this.args.add(new Argument("int168", ContractFunctionParameters.int256(value, 168), false));
        return this;
    }

    public ContractFunctionParameters addInt176(BigInteger value) {
        this.args.add(new Argument("int176", ContractFunctionParameters.int256(value, 176), false));
        return this;
    }

    public ContractFunctionParameters addInt184(BigInteger value) {
        this.args.add(new Argument("int184", ContractFunctionParameters.int256(value, 184), false));
        return this;
    }

    public ContractFunctionParameters addInt192(BigInteger value) {
        this.args.add(new Argument("int192", ContractFunctionParameters.int256(value, 192), false));
        return this;
    }

    public ContractFunctionParameters addInt200(BigInteger value) {
        this.args.add(new Argument("int200", ContractFunctionParameters.int256(value, 200), false));
        return this;
    }

    public ContractFunctionParameters addInt208(BigInteger value) {
        this.args.add(new Argument("int208", ContractFunctionParameters.int256(value, 208), false));
        return this;
    }

    public ContractFunctionParameters addInt216(BigInteger value) {
        this.args.add(new Argument("int216", ContractFunctionParameters.int256(value, 216), false));
        return this;
    }

    public ContractFunctionParameters addInt224(BigInteger value) {
        this.args.add(new Argument("int224", ContractFunctionParameters.int256(value, 224), false));
        return this;
    }

    public ContractFunctionParameters addInt232(BigInteger value) {
        this.args.add(new Argument("int232", ContractFunctionParameters.int256(value, 232), false));
        return this;
    }

    public ContractFunctionParameters addInt240(BigInteger value) {
        this.args.add(new Argument("int240", ContractFunctionParameters.int256(value, 240), false));
        return this;
    }

    public ContractFunctionParameters addInt248(BigInteger value) {
        this.args.add(new Argument("int248", ContractFunctionParameters.int256(value, 248), false));
        return this;
    }

    public ContractFunctionParameters addInt256(BigInteger value) {
        this.args.add(new Argument("int256", ContractFunctionParameters.int256(value, 256), false));
        return this;
    }

    public ContractFunctionParameters addInt8Array(byte[] intArray) {
        IntStream intStream = IntStream.range(0, intArray.length).map(idx -> intArray[idx]);
        ByteString arrayBytes = ByteString.copyFrom((Iterable)intStream.mapToObj(i -> ContractFunctionParameters.int256(i, 8)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int8[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt16Array(int[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.int256(i, 16)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int16[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt24Array(int[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.int256(i, 24)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int24[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt32Array(int[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.int256(i, 32)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int32[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt40Array(long[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.int256(i, 40)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int40[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt48Array(long[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.int256(i, 48)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int48[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt56Array(long[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.int256(i, 56)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int56[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt64Array(long[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.int256(i, 64)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int64[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt72Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 72)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int72[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt80Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 80)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int80[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt88Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 88)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int88[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt96Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 96)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int96[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt104Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 104)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int104[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt112Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 112)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int112[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt120Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 120)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int120[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt128Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 128)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int128[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt136Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 136)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int136[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt144Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 144)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int144[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt152Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 152)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int152[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt160Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 160)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int160[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt168Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 168)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int168[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt176Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 176)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int176[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt184Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 184)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int184[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt192Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 192)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int192[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt200Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 200)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int200[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt208Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 208)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int208[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt216Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 216)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int216[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt224Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 224)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int224[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt232Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 232)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int232[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt240Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 240)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int240[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt248Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 248)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int248[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt256Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.int256(i, 256)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int256[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint8(byte value) {
        this.args.add(new Argument("uint8", ContractFunctionParameters.uint256(value, 8), false));
        return this;
    }

    public ContractFunctionParameters addUint16(int value) {
        this.args.add(new Argument("uint16", ContractFunctionParameters.uint256(value, 16), false));
        return this;
    }

    public ContractFunctionParameters addUint24(int value) {
        this.args.add(new Argument("uint24", ContractFunctionParameters.uint256(value, 24), false));
        return this;
    }

    public ContractFunctionParameters addUint32(int value) {
        this.args.add(new Argument("uint32", ContractFunctionParameters.uint256(value, 32), false));
        return this;
    }

    public ContractFunctionParameters addUint40(long value) {
        this.args.add(new Argument("uint40", ContractFunctionParameters.uint256(value, 40), false));
        return this;
    }

    public ContractFunctionParameters addUint48(long value) {
        this.args.add(new Argument("uint48", ContractFunctionParameters.uint256(value, 48), false));
        return this;
    }

    public ContractFunctionParameters addUint56(long value) {
        this.args.add(new Argument("uint56", ContractFunctionParameters.uint256(value, 56), false));
        return this;
    }

    public ContractFunctionParameters addUint64(long value) {
        this.args.add(new Argument("uint64", ContractFunctionParameters.uint256(value, 64), false));
        return this;
    }

    public ContractFunctionParameters addUint72(BigInteger value) {
        this.args.add(new Argument("uint72", ContractFunctionParameters.uint256(value, 72), false));
        return this;
    }

    public ContractFunctionParameters addUint80(BigInteger value) {
        this.args.add(new Argument("uint80", ContractFunctionParameters.uint256(value, 80), false));
        return this;
    }

    public ContractFunctionParameters addUint88(BigInteger value) {
        this.args.add(new Argument("uint88", ContractFunctionParameters.uint256(value, 88), false));
        return this;
    }

    public ContractFunctionParameters addUint96(BigInteger value) {
        this.args.add(new Argument("uint96", ContractFunctionParameters.uint256(value, 96), false));
        return this;
    }

    public ContractFunctionParameters addUint104(BigInteger value) {
        this.args.add(new Argument("uint104", ContractFunctionParameters.uint256(value, 104), false));
        return this;
    }

    public ContractFunctionParameters addUint112(BigInteger value) {
        this.args.add(new Argument("uint112", ContractFunctionParameters.uint256(value, 112), false));
        return this;
    }

    public ContractFunctionParameters addUint120(BigInteger value) {
        this.args.add(new Argument("uint120", ContractFunctionParameters.uint256(value, 120), false));
        return this;
    }

    public ContractFunctionParameters addUint128(BigInteger value) {
        this.args.add(new Argument("uint128", ContractFunctionParameters.uint256(value, 128), false));
        return this;
    }

    public ContractFunctionParameters addUint136(BigInteger value) {
        this.args.add(new Argument("uint136", ContractFunctionParameters.uint256(value, 136), false));
        return this;
    }

    public ContractFunctionParameters addUint144(BigInteger value) {
        this.args.add(new Argument("uint144", ContractFunctionParameters.uint256(value, 144), false));
        return this;
    }

    public ContractFunctionParameters addUint152(BigInteger value) {
        this.args.add(new Argument("uint152", ContractFunctionParameters.uint256(value, 152), false));
        return this;
    }

    public ContractFunctionParameters addUint160(BigInteger value) {
        this.args.add(new Argument("uint160", ContractFunctionParameters.uint256(value, 160), false));
        return this;
    }

    public ContractFunctionParameters addUint168(BigInteger value) {
        this.args.add(new Argument("uint168", ContractFunctionParameters.uint256(value, 168), false));
        return this;
    }

    public ContractFunctionParameters addUint176(BigInteger value) {
        this.args.add(new Argument("uint176", ContractFunctionParameters.uint256(value, 176), false));
        return this;
    }

    public ContractFunctionParameters addUint184(BigInteger value) {
        this.args.add(new Argument("uint184", ContractFunctionParameters.uint256(value, 184), false));
        return this;
    }

    public ContractFunctionParameters addUint192(BigInteger value) {
        this.args.add(new Argument("uint192", ContractFunctionParameters.uint256(value, 192), false));
        return this;
    }

    public ContractFunctionParameters addUint200(BigInteger value) {
        this.args.add(new Argument("uint200", ContractFunctionParameters.uint256(value, 200), false));
        return this;
    }

    public ContractFunctionParameters addUint208(BigInteger value) {
        this.args.add(new Argument("uint208", ContractFunctionParameters.uint256(value, 208), false));
        return this;
    }

    public ContractFunctionParameters addUint216(BigInteger value) {
        this.args.add(new Argument("uint216", ContractFunctionParameters.uint256(value, 216), false));
        return this;
    }

    public ContractFunctionParameters addUint224(BigInteger value) {
        this.args.add(new Argument("uint224", ContractFunctionParameters.uint256(value, 224), false));
        return this;
    }

    public ContractFunctionParameters addUint232(BigInteger value) {
        this.args.add(new Argument("uint232", ContractFunctionParameters.uint256(value, 232), false));
        return this;
    }

    public ContractFunctionParameters addUint240(BigInteger value) {
        this.args.add(new Argument("uint240", ContractFunctionParameters.uint256(value, 240), false));
        return this;
    }

    public ContractFunctionParameters addUint248(BigInteger value) {
        this.args.add(new Argument("uint248", ContractFunctionParameters.uint256(value, 248), false));
        return this;
    }

    public ContractFunctionParameters addUint256(BigInteger value) {
        this.args.add(new Argument("uint256", ContractFunctionParameters.uint256(value, 256), false));
        return this;
    }

    public ContractFunctionParameters addUint8Array(byte[] intArray) {
        IntStream intStream = IntStream.range(0, intArray.length).map(idx -> intArray[idx]);
        ByteString arrayBytes = ByteString.copyFrom((Iterable)intStream.mapToObj(i -> ContractFunctionParameters.uint256(i, 8)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint8[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint16Array(int[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.uint256(i, 16)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint16[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint24Array(int[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.uint256(i, 24)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint24[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint32Array(int[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.uint256(i, 32)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint32[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint40Array(long[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.uint256(i, 40)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint40[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint48Array(long[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.uint256(i, 48)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint48[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint56Array(long[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.uint256(i, 56)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint56[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint64Array(long[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.uint256(i, 64)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint64[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint72Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 72)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint72[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint80Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 80)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint80[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint88Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 88)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint88[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint96Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 96)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint96[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint104Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 104)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint104[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint112Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 112)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint112[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint120Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 120)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint120[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint128Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 128)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint128[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint136Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 136)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint136[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint144Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 144)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint144[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint152Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 152)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint152[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint160Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 160)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint160[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint168Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 168)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint168[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint176Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 176)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint176[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint184Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 184)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint184[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint192Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 192)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint192[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint200Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 200)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint200[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint208Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 208)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint208[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint216Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 216)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint216[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint224Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 224)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint224[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint232Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 232)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint232[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint240Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 240)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint240[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint248Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 248)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint248[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint256Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(i -> ContractFunctionParameters.uint256(i, 256)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint256[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addAddress(String address) {
        byte[] addressBytes = ContractFunctionParameters.decodeAddress(address);
        this.args.add(new Argument("address", ContractFunctionParameters.leftPad32(ByteString.copyFrom((byte[])addressBytes)), false));
        return this;
    }

    public ContractFunctionParameters addAddressArray(String[] addresses) {
        ByteString addressArray = ContractFunctionParameters.encodeArray(Arrays.stream(addresses).map(a -> {
            byte[] address = ContractFunctionParameters.decodeAddress(a);
            return ContractFunctionParameters.leftPad32(ByteString.copyFrom((byte[])address));
        }));
        this.args.add(new Argument("address[]", addressArray, true));
        return this;
    }

    public ContractFunctionParameters addFunction(String address, byte[] selector) {
        return this.addFunction(ContractFunctionParameters.decodeAddress(address), selector);
    }

    public ContractFunctionParameters addFunction(String address, ContractFunctionSelector selector) {
        return this.addFunction(ContractFunctionParameters.decodeAddress(address), selector.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContractFunctionParameters addFunction(byte[] address, byte[] selector) {
        if (selector.length != 4) {
            throw new IllegalArgumentException("function selectors must be 4 bytes or 8 hex chars");
        }
        ByteString.Output output = ByteString.newOutput((int)24);
        try {
            output.write(address, 0, address.length);
            output.write(selector, 0, selector.length);
            this.args.add(new Argument("function", ContractFunctionParameters.rightPad32(output.toByteString()), false));
            ContractFunctionParameters contractFunctionParameters = this;
            return contractFunctionParameters;
        }
        finally {
            try {
                output.close();
            }
            catch (Throwable throwable) {}
        }
    }

    ByteString toBytes(@Nullable String funcName) {
        int dynamicOffset = this.args.size() * 32;
        ArrayList<Object> paramsBytes = new ArrayList<Object>(this.args.size() + 1);
        ArrayList<ByteString> dynamicArgs = new ArrayList<ByteString>();
        ContractFunctionSelector functionSelector = funcName != null ? new ContractFunctionSelector(funcName) : null;
        for (Argument arg : this.args) {
            if (functionSelector != null) {
                functionSelector.addParamType(arg.type);
            }
            if (arg.isDynamic) {
                paramsBytes.add(ContractFunctionParameters.int256(dynamicOffset, 256));
                dynamicArgs.add(arg.value);
                dynamicOffset += arg.value.size();
                continue;
            }
            paramsBytes.add(arg.value);
        }
        if (functionSelector != null) {
            paramsBytes.add(0, ByteString.copyFrom((byte[])functionSelector.finish()));
        }
        paramsBytes.addAll(dynamicArgs);
        return ByteString.copyFrom(paramsBytes);
    }

    static {
        byte[] fill = new byte[31];
        Arrays.fill(fill, (byte)-1);
        negativePadding = ByteString.copyFrom((byte[])fill);
    }

    private static final class Argument {
        private final String type;
        private final ByteString value;
        private final boolean isDynamic;

        private Argument(String type, ByteString value, boolean isDynamic) {
            this.type = type;
            if (!isDynamic && value.size() != 32) {
                throw new IllegalArgumentException("value argument that was not 32 bytes");
            }
            this.value = value;
            this.isDynamic = isDynamic;
        }
    }
}

