/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.ChunkedTransaction;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.FileAppendTransactionBody;
import com.hedera.hashgraph.sdk.proto.FileServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.SignedTransaction;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionID;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class FileAppendTransaction
extends ChunkedTransaction<FileAppendTransaction> {
    @Nullable
    private FileId fileId = null;

    public FileAppendTransaction() {
        this.defaultMaxTransactionFee = new Hbar(5L);
        this.setChunkSize(2048);
    }

    FileAppendTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    FileAppendTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public FileId getFileId() {
        return this.fileId;
    }

    public FileAppendTransaction setFileId(FileId fileId) {
        Objects.requireNonNull(fileId);
        this.requireNotFrozen();
        this.fileId = fileId;
        return this;
    }

    @Nullable
    public ByteString getContents() {
        return this.getData();
    }

    public FileAppendTransaction setContents(byte[] contents) {
        return (FileAppendTransaction)this.setData(contents);
    }

    public FileAppendTransaction setContents(ByteString contents) {
        return (FileAppendTransaction)this.setData(contents);
    }

    public FileAppendTransaction setContents(String text) {
        return (FileAppendTransaction)this.setData(text);
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.fileId != null) {
            this.fileId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return FileServiceGrpc.getAppendContentMethod();
    }

    void initFromTransactionBody() {
        FileAppendTransactionBody body = this.sourceTransactionBody.getFileAppend();
        if (body.hasFileID()) {
            this.fileId = FileId.fromProtobuf(body.getFileID());
        }
        try {
            for (int i = 0; i < this.innerSignedTransactions.size(); i += this.nodeAccountIds.isEmpty() ? 1 : this.nodeAccountIds.size()) {
                this.data = this.data.concat(TransactionBody.parseFrom(((SignedTransaction.Builder)this.innerSignedTransactions.get(i)).getBodyBytes()).getFileAppend().getContents());
            }
        }
        catch (InvalidProtocolBufferException exc) {
            throw new IllegalArgumentException(exc.getMessage());
        }
    }

    FileAppendTransactionBody.Builder build() {
        FileAppendTransactionBody.Builder builder = FileAppendTransactionBody.newBuilder();
        if (this.fileId != null) {
            builder.setFileID(this.fileId.toProtobuf());
        }
        builder.setContents(this.data);
        return builder;
    }

    @Override
    void onFreezeChunk(TransactionBody.Builder body, @Nullable TransactionID initialTransactionId, int startIndex, int endIndex, int chunk, int total) {
        body.setFileAppend(this.build().setContents(this.data.substring(startIndex, endIndex)));
    }

    @Override
    boolean shouldGetReceipt() {
        return true;
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setFileAppend(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setFileAppend(this.build().setContents(this.data));
    }
}

