/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.NetworkName;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public class LedgerId {
    private final byte[] idBytes;
    public static final LedgerId MAINNET = new LedgerId(new byte[]{0});
    public static final LedgerId TESTNET = new LedgerId(new byte[]{1});
    public static final LedgerId PREVIEWNET = new LedgerId(new byte[]{2});

    LedgerId(byte[] idBytes) {
        this.idBytes = idBytes;
    }

    public static LedgerId fromString(String string) {
        switch (string) {
            case "mainnet": {
                return MAINNET;
            }
            case "testnet": {
                return TESTNET;
            }
            case "previewnet": {
                return PREVIEWNET;
            }
        }
        return new LedgerId(Hex.decode((String)string));
    }

    public static LedgerId fromBytes(byte[] bytes) {
        return new LedgerId(bytes);
    }

    static LedgerId fromByteString(ByteString byteString) {
        return LedgerId.fromBytes(byteString.toByteArray());
    }

    @Deprecated
    public static LedgerId fromNetworkName(NetworkName networkName) {
        switch (networkName) {
            case MAINNET: {
                return MAINNET;
            }
            case TESTNET: {
                return TESTNET;
            }
            case PREVIEWNET: {
                return PREVIEWNET;
            }
        }
        throw new IllegalArgumentException("networkName must be MAINNET, TESTNET, or PREVIEWNET");
    }

    public boolean isMainnet() {
        return this.equals(MAINNET);
    }

    public boolean isTestnet() {
        return this.equals(TESTNET);
    }

    public boolean isPreviewnet() {
        return this.equals(PREVIEWNET);
    }

    boolean isKnownNetwork() {
        return this.isMainnet() || this.isTestnet() || this.isPreviewnet();
    }

    public String toString() {
        if (this.isMainnet()) {
            return "mainnet";
        }
        if (this.isTestnet()) {
            return "testnet";
        }
        if (this.isPreviewnet()) {
            return "previewnet";
        }
        return Hex.toHexString((byte[])this.idBytes);
    }

    public byte[] toBytes() {
        return this.idBytes;
    }

    ByteString toByteString() {
        return ByteString.copyFrom((byte[])this.idBytes);
    }

    @Deprecated
    public NetworkName toNetworkName() {
        if (this.isMainnet()) {
            return NetworkName.MAINNET;
        }
        if (this.isTestnet()) {
            return NetworkName.TESTNET;
        }
        if (this.isPreviewnet()) {
            return NetworkName.PREVIEWNET;
        }
        return NetworkName.OTHER;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LedgerId)) {
            return false;
        }
        LedgerId otherId = (LedgerId)o;
        return Arrays.equals(this.idBytes, otherId.idBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.idBytes);
    }
}

