/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.ScheduleCreateTransactionBody;
import com.hedera.hashgraph.sdk.proto.ScheduleServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ScheduleCreateTransaction
extends com.hedera.hashgraph.sdk.Transaction<ScheduleCreateTransaction> {
    @Nullable
    private AccountId payerAccountId = null;
    @Nullable
    private SchedulableTransactionBody transactionToSchedule = null;
    @Nullable
    private Key adminKey = null;
    private String scheduleMemo = "";

    public ScheduleCreateTransaction() {
        this.defaultMaxTransactionFee = new Hbar(5L);
    }

    ScheduleCreateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    @Nullable
    public AccountId getPayerAccountId() {
        return this.payerAccountId;
    }

    public ScheduleCreateTransaction setPayerAccountId(AccountId accountId) {
        Objects.requireNonNull(accountId);
        this.requireNotFrozen();
        this.payerAccountId = accountId;
        return this;
    }

    public ScheduleCreateTransaction setScheduledTransaction(com.hedera.hashgraph.sdk.Transaction<?> transaction) {
        this.requireNotFrozen();
        Objects.requireNonNull(transaction);
        ScheduleCreateTransaction scheduled = transaction.schedule();
        this.transactionToSchedule = scheduled.transactionToSchedule;
        return this;
    }

    ScheduleCreateTransaction setScheduledTransactionBody(SchedulableTransactionBody tx) {
        this.requireNotFrozen();
        Objects.requireNonNull(tx);
        this.transactionToSchedule = tx;
        return this;
    }

    @Nullable
    public Key getAdminKey() {
        return this.adminKey;
    }

    public ScheduleCreateTransaction setAdminKey(Key key) {
        this.requireNotFrozen();
        this.adminKey = key;
        return this;
    }

    public String getScheduleMemo() {
        return this.scheduleMemo;
    }

    public ScheduleCreateTransaction setScheduleMemo(String memo) {
        this.requireNotFrozen();
        this.scheduleMemo = memo;
        return this;
    }

    ScheduleCreateTransactionBody.Builder build() {
        ScheduleCreateTransactionBody.Builder builder = ScheduleCreateTransactionBody.newBuilder();
        if (this.payerAccountId != null) {
            builder.setPayerAccountID(this.payerAccountId.toProtobuf());
        }
        if (this.transactionToSchedule != null) {
            builder.setScheduledTransactionBody(this.transactionToSchedule);
        }
        if (this.adminKey != null) {
            builder.setAdminKey(this.adminKey.toProtobufKey());
        }
        builder.setMemo(this.scheduleMemo);
        return builder;
    }

    void initFromTransactionBody() {
        ScheduleCreateTransactionBody body = this.sourceTransactionBody.getScheduleCreate();
        if (body.hasPayerAccountID()) {
            this.payerAccountId = AccountId.fromProtobuf(body.getPayerAccountID());
        }
        if (body.hasScheduledTransactionBody()) {
            this.transactionToSchedule = body.getScheduledTransactionBody();
        }
        if (body.hasAdminKey()) {
            this.adminKey = Key.fromProtobufKey(body.getAdminKey());
        }
        this.scheduleMemo = body.getMemo();
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.payerAccountId != null) {
            this.payerAccountId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return ScheduleServiceGrpc.getCreateScheduleMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setScheduleCreate(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        throw new UnsupportedOperationException("Cannot schedule ScheduleCreateTransaction");
    }
}

