/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.TokenUnfreezeAccountTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public class TokenUnfreezeTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenUnfreezeTransaction> {
    @Nullable
    private TokenId tokenId = null;
    @Nullable
    private AccountId accountId = null;

    public TokenUnfreezeTransaction() {
    }

    TokenUnfreezeTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TokenUnfreezeTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public TokenId getTokenId() {
        return this.tokenId;
    }

    public TokenUnfreezeTransaction setTokenId(TokenId tokenId) {
        Objects.requireNonNull(tokenId);
        this.requireNotFrozen();
        this.tokenId = tokenId;
        return this;
    }

    @Nullable
    public AccountId getAccountId() {
        return this.accountId;
    }

    public TokenUnfreezeTransaction setAccountId(AccountId accountId) {
        Objects.requireNonNull(accountId);
        this.requireNotFrozen();
        this.accountId = accountId;
        return this;
    }

    void initFromTransactionBody() {
        TokenUnfreezeAccountTransactionBody body = this.sourceTransactionBody.getTokenUnfreeze();
        if (body.hasToken()) {
            this.tokenId = TokenId.fromProtobuf(body.getToken());
        }
        if (body.hasAccount()) {
            this.accountId = AccountId.fromProtobuf(body.getAccount());
        }
    }

    TokenUnfreezeAccountTransactionBody.Builder build() {
        TokenUnfreezeAccountTransactionBody.Builder builder = TokenUnfreezeAccountTransactionBody.newBuilder();
        if (this.tokenId != null) {
            builder.setToken(this.tokenId.toProtobuf());
        }
        if (this.accountId != null) {
            builder.setAccount(this.accountId.toProtobuf());
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.tokenId != null) {
            this.tokenId.validateChecksum(client);
        }
        if (this.accountId != null) {
            this.accountId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getFreezeTokenAccountMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenUnfreeze(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setTokenUnfreeze(this.build());
    }
}

