/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.ReceiptStatusException;
import com.hedera.hashgraph.sdk.TransactionReceipt;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface WithGetReceipt {
    public CompletableFuture<TransactionReceipt> getReceiptAsync(Client var1);

    default public void getReceiptAsync(Client client, BiConsumer<TransactionReceipt, Throwable> callback) {
        this.getReceiptAsync(client, client.getRequestTimeout(), callback);
    }

    default public void getReceiptAsync(Client client, Duration timeout, BiConsumer<TransactionReceipt, Throwable> callback) {
        this.getReceiptAsync(client).orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).whenComplete((BiConsumer)callback);
    }

    default public void getReceiptAsync(Client client, Consumer<TransactionReceipt> onSuccess, Consumer<Throwable> onFailure) {
        this.getReceiptAsync(client, client.getRequestTimeout(), onSuccess, onFailure);
    }

    default public void getReceiptAsync(Client client, Duration timeout, Consumer<TransactionReceipt> onSuccess, Consumer<Throwable> onFailure) {
        this.getReceiptAsync(client).orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).whenComplete((output, error) -> {
            if (error != null) {
                onFailure.accept((Throwable)error);
            } else {
                onSuccess.accept((TransactionReceipt)output);
            }
        });
    }

    default public TransactionReceipt getReceipt(Client client) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        return this.getReceipt(client, client.getRequestTimeout());
    }

    default public TransactionReceipt getReceipt(Client client, Duration timeout) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        try {
            return this.getReceiptAsync(client).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new RuntimeException(e);
            }
            if (cause instanceof PrecheckStatusException) {
                throw (PrecheckStatusException)cause;
            }
            if (cause instanceof ReceiptStatusException) {
                throw (ReceiptStatusException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

