/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.CryptoCreateTransactionBody;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class AccountCreateTransaction
extends com.hedera.hashgraph.sdk.Transaction<AccountCreateTransaction> {
    @Nullable
    private AccountId proxyAccountId = null;
    @Nullable
    private Key key = null;
    private String accountMemo = "";
    private Hbar initialBalance = new Hbar(0L);
    private boolean receiverSigRequired = false;
    private Duration autoRenewPeriod = DEFAULT_AUTO_RENEW_PERIOD;
    private int maxAutomaticTokenAssociations = 0;
    @Nullable
    private AccountId stakedAccountId = null;
    @Nullable
    private Long stakedNodeId = null;
    private boolean declineStakingReward = false;

    public AccountCreateTransaction() {
    }

    AccountCreateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    AccountCreateTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public Key getKey() {
        return this.key;
    }

    public AccountCreateTransaction setKey(Key key) {
        Objects.requireNonNull(key);
        this.requireNotFrozen();
        this.key = key;
        return this;
    }

    public Hbar getInitialBalance() {
        return this.initialBalance;
    }

    public AccountCreateTransaction setInitialBalance(Hbar initialBalance) {
        Objects.requireNonNull(initialBalance);
        this.requireNotFrozen();
        this.initialBalance = initialBalance;
        return this;
    }

    public boolean getReceiverSignatureRequired() {
        return this.receiverSigRequired;
    }

    public AccountCreateTransaction setReceiverSignatureRequired(boolean receiveSignatureRequired) {
        this.requireNotFrozen();
        this.receiverSigRequired = receiveSignatureRequired;
        return this;
    }

    @Nullable
    public AccountId getProxyAccountId() {
        return this.proxyAccountId;
    }

    public AccountCreateTransaction setProxyAccountId(AccountId proxyAccountId) {
        this.requireNotFrozen();
        Objects.requireNonNull(proxyAccountId);
        this.proxyAccountId = proxyAccountId;
        return this;
    }

    @Nullable
    public Duration getAutoRenewPeriod() {
        return this.autoRenewPeriod;
    }

    public AccountCreateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        this.requireNotFrozen();
        Objects.requireNonNull(autoRenewPeriod);
        this.autoRenewPeriod = autoRenewPeriod;
        return this;
    }

    public int getMaxAutomaticTokenAssociations() {
        return this.maxAutomaticTokenAssociations;
    }

    public AccountCreateTransaction setMaxAutomaticTokenAssociations(int amount) {
        this.requireNotFrozen();
        this.maxAutomaticTokenAssociations = amount;
        return this;
    }

    public String getAccountMemo() {
        return this.accountMemo;
    }

    public AccountCreateTransaction setAccountMemo(String memo) {
        Objects.requireNonNull(memo);
        this.requireNotFrozen();
        this.accountMemo = memo;
        return this;
    }

    @Nullable
    public AccountId getStakedAccountId() {
        return this.stakedAccountId;
    }

    public AccountCreateTransaction setStakedAccountId(@Nullable AccountId stakedAccountId) {
        this.stakedAccountId = stakedAccountId;
        return this;
    }

    @Nullable
    public Long getStakedNodeId() {
        return this.stakedNodeId;
    }

    public AccountCreateTransaction setStakedNodeId(@Nullable Long stakedNodeId) {
        this.stakedNodeId = stakedNodeId;
        return this;
    }

    public boolean getDeclineStakingReward() {
        return this.declineStakingReward;
    }

    public AccountCreateTransaction setDeclineStakingReward(boolean declineStakingReward) {
        this.declineStakingReward = declineStakingReward;
        return this;
    }

    CryptoCreateTransactionBody.Builder build() {
        CryptoCreateTransactionBody.Builder builder = CryptoCreateTransactionBody.newBuilder().setInitialBalance(this.initialBalance.toTinybars()).setReceiverSigRequired(this.receiverSigRequired).setAutoRenewPeriod(DurationConverter.toProtobuf(this.autoRenewPeriod)).setMemo(this.accountMemo).setMaxAutomaticTokenAssociations(this.maxAutomaticTokenAssociations).setDeclineReward(this.declineStakingReward);
        if (this.proxyAccountId != null) {
            builder.setProxyAccountID(this.proxyAccountId.toProtobuf());
        }
        if (this.key != null) {
            builder.setKey(this.key.toProtobufKey());
        }
        if (this.stakedAccountId != null) {
            builder.setStakedAccountId(this.stakedAccountId.toProtobuf());
        }
        if (this.stakedNodeId != null) {
            builder.setStakedNodeId(this.stakedNodeId);
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.proxyAccountId != null) {
            this.proxyAccountId.validateChecksum(client);
        }
        if (this.stakedAccountId != null) {
            this.stakedAccountId.validateChecksum(client);
        }
    }

    void initFromTransactionBody() {
        CryptoCreateTransactionBody body = this.sourceTransactionBody.getCryptoCreateAccount();
        if (body.hasProxyAccountID()) {
            this.proxyAccountId = AccountId.fromProtobuf(body.getProxyAccountID());
        }
        if (body.hasKey()) {
            this.key = Key.fromProtobufKey(body.getKey());
        }
        if (body.hasAutoRenewPeriod()) {
            this.autoRenewPeriod = DurationConverter.fromProtobuf(body.getAutoRenewPeriod());
        }
        this.initialBalance = Hbar.fromTinybars(body.getInitialBalance());
        this.accountMemo = body.getMemo();
        this.receiverSigRequired = body.getReceiverSigRequired();
        this.maxAutomaticTokenAssociations = body.getMaxAutomaticTokenAssociations();
        this.declineStakingReward = body.getDeclineReward();
        if (body.hasStakedAccountId()) {
            this.stakedAccountId = AccountId.fromProtobuf(body.getStakedAccountId());
        }
        if (body.hasStakedNodeId()) {
            this.stakedNodeId = body.getStakedNodeId();
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getCreateAccountMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setCryptoCreateAccount(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setCryptoCreateAccount(this.build());
    }
}

