/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.hedera.hashgraph.sdk.AccountBalanceQuery;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.LedgerId;
import com.hedera.hashgraph.sdk.MirrorNetwork;
import com.hedera.hashgraph.sdk.Network;
import com.hedera.hashgraph.sdk.NetworkName;
import com.hedera.hashgraph.sdk.PrivateKey;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.WithPing;
import com.hedera.hashgraph.sdk.WithPingAll;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Client
implements AutoCloseable,
WithPing,
WithPingAll {
    static final int DEFAULT_MAX_ATTEMPTS = 10;
    static final Duration DEFAULT_MAX_BACKOFF = Duration.ofSeconds(8L);
    static final Duration DEFAULT_MIN_BACKOFF = Duration.ofMillis(250L);
    static final Duration DEFAULT_MAX_NODE_BACKOFF = Duration.ofHours(1L);
    static final Duration DEFAULT_MIN_NODE_BACKOFF = Duration.ofSeconds(8L);
    static final Duration DEFAULT_CLOSE_TIMEOUT = Duration.ofSeconds(30L);
    static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofMinutes(2L);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Hbar DEFAULT_MAX_QUERY_PAYMENT = new Hbar(1L);
    final ExecutorService executor;
    @Nullable
    Hbar defaultMaxTransactionFee = null;
    Hbar defaultMaxQueryPayment = DEFAULT_MAX_QUERY_PAYMENT;
    Network network;
    MirrorNetwork mirrorNetwork;
    @Nullable
    private Operator operator;
    private Duration requestTimeout = DEFAULT_REQUEST_TIMEOUT;
    private Duration closeTimeout = DEFAULT_CLOSE_TIMEOUT;
    private int maxAttempts = 10;
    private volatile Duration maxBackoff = DEFAULT_MAX_BACKOFF;
    private volatile Duration minBackoff = DEFAULT_MIN_BACKOFF;
    private boolean autoValidateChecksums = false;
    private boolean defaultRegenerateTransactionId = true;

    Client(ExecutorService executor, Network network, MirrorNetwork mirrorNetwork) {
        this.executor = executor;
        this.network = network;
        this.mirrorNetwork = mirrorNetwork;
    }

    static ExecutorService createExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("hedera-sdk-%d").setDaemon(true).build();
        return Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), threadFactory);
    }

    public synchronized Client setMirrorNetwork(List<String> network) throws InterruptedException {
        try {
            this.mirrorNetwork.setNetwork(network);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public List<String> getMirrorNetwork() {
        return this.mirrorNetwork.getNetwork();
    }

    public static Client forNetwork(Map<String, AccountId> networkMap) {
        ExecutorService executor = Client.createExecutor();
        Network network = Network.forNetwork(executor, networkMap);
        MirrorNetwork mirrorNetwork = MirrorNetwork.forNetwork(executor, new ArrayList<String>());
        return new Client(executor, network, mirrorNetwork);
    }

    public static Client forName(String name) {
        switch (name) {
            case "mainnet": {
                return Client.forMainnet();
            }
            case "testnet": {
                return Client.forTestnet();
            }
            case "previewnet": {
                return Client.forPreviewnet();
            }
        }
        throw new IllegalArgumentException("Name must be one-of `mainnet`, `testnet`, or `previewnet`");
    }

    public static Client forMainnet() {
        ExecutorService executor = Client.createExecutor();
        Network network = Network.forMainnet(executor);
        MirrorNetwork mirrorNetwork = MirrorNetwork.forMainnet(executor);
        return new Client(executor, network, mirrorNetwork);
    }

    public static Client forTestnet() {
        ExecutorService executor = Client.createExecutor();
        Network network = Network.forTestnet(executor);
        MirrorNetwork mirrorNetwork = MirrorNetwork.forTestnet(executor);
        return new Client(executor, network, mirrorNetwork);
    }

    public static Client forPreviewnet() {
        ExecutorService executor = Client.createExecutor();
        Network network = Network.forPreviewnet(executor);
        MirrorNetwork mirrorNetwork = MirrorNetwork.forPreviewnet(executor);
        return new Client(executor, network, mirrorNetwork);
    }

    public static Client fromConfig(String json) throws Exception {
        return Client.fromConfig(new StringReader(json));
    }

    public static Client fromConfig(Reader json) throws Exception {
        Client client;
        Object networks;
        Config config = (Config)new Gson().fromJson(json, Config.class);
        if (config.network == null) {
            throw new Exception("Network is not set in provided json object");
        }
        if (config.network.isJsonObject()) {
            networks = config.network.getAsJsonObject();
            Object nodes = new HashMap(networks.size());
            for (Map.Entry entry : networks.entrySet()) {
                nodes.put(((JsonElement)entry.getValue()).toString().replace("\"", ""), AccountId.fromString(((String)entry.getKey()).replace("\"", "")));
            }
            client = Client.forNetwork((Map<String, AccountId>)nodes);
            if (config.networkName != null) {
                String networkNameString = config.networkName.getAsString();
                try {
                    client.setNetworkName(NetworkName.fromString(networkNameString));
                }
                catch (Exception ignored) {
                    throw new IllegalArgumentException("networkName in config was \"" + networkNameString + "\", expected either \"mainnet\", \"testnet\" or \"previewnet\"");
                }
            }
        } else {
            switch (networks = config.network.getAsString()) {
                case "mainnet": {
                    client = Client.forMainnet();
                    break;
                }
                case "testnet": {
                    client = Client.forTestnet();
                    break;
                }
                case "previewnet": {
                    client = Client.forPreviewnet();
                    break;
                }
                default: {
                    throw new JsonParseException("Illegal argument for network.");
                }
            }
        }
        if (config.operator != null) {
            AccountId operatorAccount = AccountId.fromString(config.operator.accountId);
            PrivateKey privateKey = PrivateKey.fromString(config.operator.privateKey);
            client.setOperator(operatorAccount, privateKey);
        }
        if (config.mirrorNetwork != null) {
            if (config.mirrorNetwork.isJsonArray()) {
                JsonArray mirrors = config.mirrorNetwork.getAsJsonArray();
                ArrayList<String> listMirrors = new ArrayList<String>(mirrors.size());
                for (int i = 0; i < mirrors.size(); ++i) {
                    listMirrors.add(mirrors.get(i).getAsString().replace("\"", ""));
                }
                client.setMirrorNetwork(listMirrors);
            } else {
                String mirror;
                switch (mirror = config.mirrorNetwork.getAsString()) {
                    case "mainnet": {
                        client.setMirrorNetwork(List.of("hcs.mainnet.mirrornode.hedera.com:5600"));
                        break;
                    }
                    case "testnet": {
                        client.setMirrorNetwork(List.of("hcs.testnet.mirrornode.hedera.com:5600"));
                        break;
                    }
                    case "previewnet": {
                        client.setMirrorNetwork(List.of("hcs.previewnet.mirrornode.hedera.com:5600"));
                        break;
                    }
                    default: {
                        throw new JsonParseException("Illegal argument for mirrorNetwork.");
                    }
                }
            }
        }
        return client;
    }

    public static Client fromConfigFile(String fileName) throws Exception {
        return Client.fromConfigFile(new File(fileName));
    }

    public static Client fromConfigFile(File file) throws Exception {
        return Client.fromConfig(Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8));
    }

    public synchronized Client setNetwork(Map<String, AccountId> network) throws InterruptedException, TimeoutException {
        this.network.setNetwork(network);
        return this;
    }

    public Map<String, AccountId> getNetwork() {
        return this.network.getNetwork();
    }

    public Client setTransportSecurity(boolean transportSecurity) throws InterruptedException {
        this.network.setTransportSecurity(transportSecurity);
        return this;
    }

    public boolean isTransportSecurity() {
        return this.network.isTransportSecurity();
    }

    public Client setVerifyCertificates(boolean verifyCertificates) {
        this.network.setVerifyCertificates(verifyCertificates);
        return this;
    }

    public boolean isVerifyCertificates() {
        return this.network.isVerifyCertificates();
    }

    @Override
    public Void ping(AccountId nodeAccountId) {
        try {
            ((AccountBalanceQuery)new AccountBalanceQuery().setAccountId(nodeAccountId).setNodeAccountIds((List)Collections.singletonList(nodeAccountId))).execute(this);
        }
        catch (Exception e) {
            this.logger.debug("pinging account {} failed with exception {}", (Object)nodeAccountId, (Object)e.getMessage());
        }
        return null;
    }

    @Override
    public synchronized CompletableFuture<Void> pingAsync(AccountId nodeAccountId) {
        return ((AccountBalanceQuery)new AccountBalanceQuery().setAccountId(nodeAccountId).setNodeAccountIds((List)Collections.singletonList(nodeAccountId))).executeAsync(this).handle((balance, e) -> null);
    }

    @Override
    public synchronized Void pingAll() {
        for (AccountId nodeAccountId : this.network.getNetwork().values()) {
            this.ping(nodeAccountId);
        }
        return null;
    }

    @Override
    public synchronized CompletableFuture<Void> pingAllAsync() {
        Map<String, AccountId> network = this.network.getNetwork();
        ArrayList<CompletableFuture<Void>> list = new ArrayList<CompletableFuture<Void>>(network.size());
        for (AccountId nodeAccountId : network.values()) {
            list.add(this.pingAsync(nodeAccountId));
        }
        return CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).thenApply(v -> null);
    }

    public synchronized Client setOperator(AccountId accountId, PrivateKey privateKey) {
        return this.setOperatorWith(accountId, privateKey.getPublicKey(), privateKey::sign);
    }

    public synchronized Client setOperatorWith(AccountId accountId, PublicKey publicKey, Function<byte[], byte[]> transactionSigner) {
        if (this.getNetworkName() != null) {
            try {
                accountId.validateChecksum(this);
            }
            catch (BadEntityIdException exc) {
                throw new IllegalArgumentException("Tried to set the client operator account ID to an account ID with an invalid checksum: " + exc.getMessage());
            }
        }
        this.operator = new Operator(accountId, publicKey, transactionSigner);
        return this;
    }

    @Nullable
    @Deprecated
    public synchronized NetworkName getNetworkName() {
        LedgerId ledgerId = this.network.getLedgerId();
        return ledgerId == null ? null : ledgerId.toNetworkName();
    }

    @Deprecated
    public synchronized Client setNetworkName(@Nullable NetworkName networkName) {
        this.network.setLedgerId(networkName == null ? null : LedgerId.fromNetworkName(networkName));
        return this;
    }

    @Nullable
    public synchronized LedgerId getLedgerId() {
        return this.network.getLedgerId();
    }

    public synchronized Client setLedgerId(@Nullable LedgerId ledgerId) {
        this.network.setLedgerId(ledgerId);
        return this;
    }

    public synchronized int getMaxAttempts() {
        return this.maxAttempts;
    }

    public synchronized Client setMaxAttempts(int maxAttempts) {
        if (maxAttempts <= 0) {
            throw new IllegalArgumentException("maxAttempts must be greater than zero");
        }
        this.maxAttempts = maxAttempts;
        return this;
    }

    public Duration getMaxBackoff() {
        return this.maxBackoff;
    }

    public Client setMaxBackoff(Duration maxBackoff) {
        if (maxBackoff == null || maxBackoff.toNanos() < 0L) {
            throw new IllegalArgumentException("maxBackoff must be a positive duration");
        }
        if (maxBackoff.compareTo(this.minBackoff) < 0) {
            throw new IllegalArgumentException("maxBackoff must be greater than or equal to minBackoff");
        }
        this.maxBackoff = maxBackoff;
        return this;
    }

    public Duration getMinBackoff() {
        return this.minBackoff;
    }

    public Client setMinBackoff(Duration minBackoff) {
        if (minBackoff == null || minBackoff.toNanos() < 0L) {
            throw new IllegalArgumentException("minBackoff must be a positive duration");
        }
        if (minBackoff.compareTo(this.maxBackoff) > 0) {
            throw new IllegalArgumentException("minBackoff must be less than or equal to maxBackoff");
        }
        this.minBackoff = minBackoff;
        return this;
    }

    public synchronized int getMaxNodeAttempts() {
        return this.network.getMaxNodeAttempts();
    }

    public synchronized Client setMaxNodeAttempts(int maxNodeAttempts) {
        this.network.setMaxNodeAttempts(maxNodeAttempts);
        return this;
    }

    @Deprecated
    public synchronized Duration getNodeWaitTime() {
        return this.getNodeMinBackoff();
    }

    @Deprecated
    public synchronized Client setNodeWaitTime(Duration nodeWaitTime) {
        return this.setNodeMinBackoff(nodeWaitTime);
    }

    public synchronized Duration getNodeMinBackoff() {
        return this.network.getMinNodeBackoff();
    }

    public synchronized Client setNodeMinBackoff(Duration minBackoff) {
        this.network.setMinNodeBackoff(minBackoff);
        return this;
    }

    public synchronized Duration getNodeMaxBackoff() {
        return this.network.getMaxNodeBackoff();
    }

    public synchronized Client setNodeMaxBackoff(Duration maxBackoff) {
        this.network.setMaxNodeBackoff(maxBackoff);
        return this;
    }

    public Duration getMinNodeReadmitTime() {
        return this.network.getMinNodeReadmitTime();
    }

    public Client setMinNodeReadmitTime(Duration minNodeReadmitTime) {
        this.network.setMinNodeReadmitTime(minNodeReadmitTime);
        return this;
    }

    public Duration getMaxNodeReadmitTime() {
        return this.network.getMaxNodeReadmitTime();
    }

    public Client setMaxNodeReadmitTime(Duration maxNodeReadmitTime) {
        this.network.setMaxNodeReadmitTime(maxNodeReadmitTime);
        return this;
    }

    public synchronized Client setMaxNodesPerTransaction(int maxNodesPerTransaction) {
        this.network.setMaxNodesPerRequest(maxNodesPerTransaction);
        return this;
    }

    public synchronized Client setAutoValidateChecksums(boolean value) {
        this.autoValidateChecksums = value;
        return this;
    }

    public synchronized boolean isAutoValidateChecksumsEnabled() {
        return this.autoValidateChecksums;
    }

    @Nullable
    public synchronized AccountId getOperatorAccountId() {
        if (this.operator == null) {
            return null;
        }
        return this.operator.accountId;
    }

    @Nullable
    public synchronized PublicKey getOperatorPublicKey() {
        if (this.operator == null) {
            return null;
        }
        return this.operator.publicKey;
    }

    @Nullable
    public synchronized Hbar getDefaultMaxTransactionFee() {
        return this.defaultMaxTransactionFee;
    }

    public synchronized Client setDefaultMaxTransactionFee(Hbar defaultMaxTransactionFee) {
        Objects.requireNonNull(defaultMaxTransactionFee);
        if (defaultMaxTransactionFee.toTinybars() < 0L) {
            throw new IllegalArgumentException("maxTransactionFee must be non-negative");
        }
        this.defaultMaxTransactionFee = defaultMaxTransactionFee;
        return this;
    }

    @Deprecated
    public synchronized Client setMaxTransactionFee(Hbar maxTransactionFee) {
        return this.setDefaultMaxTransactionFee(maxTransactionFee);
    }

    public synchronized Hbar getDefaultMaxQueryPayment() {
        return this.defaultMaxQueryPayment;
    }

    public synchronized Client setDefaultMaxQueryPayment(Hbar defaultMaxQueryPayment) {
        Objects.requireNonNull(defaultMaxQueryPayment);
        if (defaultMaxQueryPayment.toTinybars() < 0L) {
            throw new IllegalArgumentException("defaultMaxQueryPayment must be non-negative");
        }
        this.defaultMaxQueryPayment = defaultMaxQueryPayment;
        return this;
    }

    @Deprecated
    public synchronized Client setMaxQueryPayment(Hbar maxQueryPayment) {
        return this.setDefaultMaxQueryPayment(maxQueryPayment);
    }

    public synchronized boolean getDefaultRegenerateTransactionId() {
        return this.defaultRegenerateTransactionId;
    }

    public synchronized Client setDefaultRegenerateTransactionId(boolean regenerateTransactionId) {
        this.defaultRegenerateTransactionId = regenerateTransactionId;
        return this;
    }

    @Override
    public synchronized Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public synchronized Client setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = Objects.requireNonNull(requestTimeout);
        return this;
    }

    public Duration getCloseTimeout() {
        return this.closeTimeout;
    }

    public Client setCloseTimeout(Duration closeTimeout) {
        this.closeTimeout = Objects.requireNonNull(closeTimeout);
        this.network.setCloseTimeout(closeTimeout);
        this.mirrorNetwork.setCloseTimeout(closeTimeout);
        return this;
    }

    @Nullable
    Operator getOperator() {
        return this.operator;
    }

    @Override
    public synchronized void close() throws TimeoutException {
        try {
            this.network.close();
            this.mirrorNetwork.close();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void close(Duration timeout) throws TimeoutException {
        try {
            this.network.close(timeout);
            this.mirrorNetwork.close(timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Config {
        @Nullable
        private JsonElement network;
        @Nullable
        private JsonElement networkName;
        @Nullable
        private ConfigOperator operator;
        @Nullable
        private JsonElement mirrorNetwork;

        private Config() {
        }

        private static class ConfigOperator {
            private String accountId = "";
            private String privateKey = "";

            private ConfigOperator() {
            }
        }
    }

    static class Operator {
        final AccountId accountId;
        final PublicKey publicKey;
        final Function<byte[], byte[]> transactionSigner;

        Operator(AccountId accountId, PublicKey publicKey, Function<byte[], byte[]> transactionSigner) {
            this.accountId = accountId;
            this.publicKey = publicKey;
            this.transactionSigner = transactionSigner;
        }
    }
}

