/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ContractFunctionParameters;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ContractCallTransactionBody;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ContractExecuteTransaction
extends com.hedera.hashgraph.sdk.Transaction<ContractExecuteTransaction> {
    @Nullable
    private ContractId contractId = null;
    private long gas = 0L;
    private Hbar payableAmount = new Hbar(0L);
    private byte[] functionParameters = new byte[0];

    public ContractExecuteTransaction() {
    }

    ContractExecuteTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    ContractExecuteTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public ContractId getContractId() {
        return this.contractId;
    }

    public ContractExecuteTransaction setContractId(ContractId contractId) {
        Objects.requireNonNull(contractId);
        this.requireNotFrozen();
        this.contractId = contractId;
        return this;
    }

    public long getGas() {
        return this.gas;
    }

    public ContractExecuteTransaction setGas(long gas) {
        this.requireNotFrozen();
        this.gas = gas;
        return this;
    }

    public Hbar getPayableAmount() {
        return this.payableAmount;
    }

    public ContractExecuteTransaction setPayableAmount(Hbar amount) {
        Objects.requireNonNull(amount);
        this.requireNotFrozen();
        this.payableAmount = amount;
        return this;
    }

    public ByteString getFunctionParameters() {
        return ByteString.copyFrom((byte[])this.functionParameters);
    }

    public ContractExecuteTransaction setFunctionParameters(ByteString functionParameters) {
        Objects.requireNonNull(functionParameters);
        this.requireNotFrozen();
        this.functionParameters = functionParameters.toByteArray();
        return this;
    }

    public ContractExecuteTransaction setFunction(String name) {
        return this.setFunction(name, new ContractFunctionParameters());
    }

    public ContractExecuteTransaction setFunction(String name, ContractFunctionParameters params) {
        Objects.requireNonNull(params);
        return this.setFunctionParameters(params.toBytes(name));
    }

    void initFromTransactionBody() {
        ContractCallTransactionBody body = this.sourceTransactionBody.getContractCall();
        if (body.hasContractID()) {
            this.contractId = ContractId.fromProtobuf(body.getContractID());
        }
        this.gas = body.getGas();
        this.payableAmount = Hbar.fromTinybars(body.getAmount());
        this.functionParameters = body.getFunctionParameters().toByteArray();
    }

    ContractCallTransactionBody.Builder build() {
        ContractCallTransactionBody.Builder builder = ContractCallTransactionBody.newBuilder();
        if (this.contractId != null) {
            builder.setContractID(this.contractId.toProtobuf());
        }
        builder.setGas(this.gas);
        builder.setAmount(this.payableAmount.toTinybars());
        builder.setFunctionParameters(ByteString.copyFrom((byte[])this.functionParameters));
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.contractId != null) {
            this.contractId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return SmartContractServiceGrpc.getContractCallMethodMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setContractCall(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setContractCall(this.build());
    }
}

