/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bouncycastle.jcajce.provider.digest.Keccak;

public final class ContractFunctionSelector {
    @Nullable
    private Keccak.Digest256 digest = new Keccak.Digest256();
    private boolean needsComma = false;
    @Nullable
    private byte[] finished = null;

    public ContractFunctionSelector(String funcName) {
        this.digest.update(funcName.getBytes(StandardCharsets.US_ASCII));
        this.digest.update((byte)40);
    }

    public ContractFunctionSelector addString() {
        return this.addParamType("string");
    }

    public ContractFunctionSelector addStringArray() {
        return this.addParamType("string[]");
    }

    public ContractFunctionSelector addBytes() {
        return this.addParamType("bytes");
    }

    public ContractFunctionSelector addBytesArray() {
        return this.addParamType("bytes[]");
    }

    public ContractFunctionSelector addBytes32() {
        return this.addParamType("bytes32");
    }

    public ContractFunctionSelector addBytes32Array() {
        return this.addParamType("bytes32[]");
    }

    public ContractFunctionSelector addBool() {
        return this.addParamType("bool");
    }

    public ContractFunctionSelector addInt8() {
        return this.addParamType("int8");
    }

    public ContractFunctionSelector addInt32() {
        return this.addParamType("int32");
    }

    public ContractFunctionSelector addInt64() {
        return this.addParamType("int64");
    }

    public ContractFunctionSelector addInt256() {
        return this.addParamType("int256");
    }

    public ContractFunctionSelector addInt8Array() {
        return this.addParamType("int8[]");
    }

    public ContractFunctionSelector addInt32Array() {
        return this.addParamType("int32[]");
    }

    public ContractFunctionSelector addInt64Array() {
        return this.addParamType("int64[]");
    }

    public ContractFunctionSelector addInt256Array() {
        return this.addParamType("int256[]");
    }

    public ContractFunctionSelector addUint8() {
        return this.addParamType("uint8");
    }

    public ContractFunctionSelector addUint32() {
        return this.addParamType("uint32");
    }

    public ContractFunctionSelector addUint64() {
        return this.addParamType("uint64");
    }

    public ContractFunctionSelector addUint256() {
        return this.addParamType("uint256");
    }

    public ContractFunctionSelector addUint8Array() {
        return this.addParamType("uint8[]");
    }

    public ContractFunctionSelector addUint32Array() {
        return this.addParamType("uint32[]");
    }

    public ContractFunctionSelector addUint64Array() {
        return this.addParamType("uint64[]");
    }

    public ContractFunctionSelector addUint256Array() {
        return this.addParamType("uint256[]");
    }

    public ContractFunctionSelector addAddress() {
        return this.addParamType("address");
    }

    public ContractFunctionSelector addAddressArray() {
        return this.addParamType("address[]");
    }

    public ContractFunctionSelector addFunction() {
        return this.addParamType("function");
    }

    ContractFunctionSelector addParamType(String typeName) {
        if (this.finished != null) {
            throw new IllegalStateException("FunctionSelector already finished");
        }
        Objects.requireNonNull(this.digest);
        if (this.needsComma) {
            this.digest.update((byte)44);
        }
        this.digest.update(typeName.getBytes(StandardCharsets.US_ASCII));
        this.needsComma = true;
        return this;
    }

    byte[] finish() {
        if (this.finished == null) {
            Objects.requireNonNull(this.digest);
            this.digest.update((byte)41);
            this.finished = Arrays.copyOf(this.digest.digest(), 4);
            this.digest = null;
        }
        return this.finished;
    }
}

