/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.CustomFee;
import com.hedera.hashgraph.sdk.CustomFixedFee;
import com.hedera.hashgraph.sdk.proto.CustomFee;
import com.hedera.hashgraph.sdk.proto.Fraction;
import com.hedera.hashgraph.sdk.proto.RoyaltyFee;
import java.util.Objects;
import javax.annotation.Nullable;

public class CustomRoyaltyFee
extends CustomFee {
    private long numerator = 0L;
    private long denominator = 1L;
    @Nullable
    private CustomFixedFee fallbackFee = null;

    static CustomRoyaltyFee clonedFrom(CustomRoyaltyFee source) {
        CustomRoyaltyFee returnFee = new CustomRoyaltyFee();
        returnFee.numerator = source.numerator;
        returnFee.denominator = source.denominator;
        returnFee.fallbackFee = source.fallbackFee;
        returnFee.feeCollectorAccountId = source.feeCollectorAccountId;
        return returnFee;
    }

    static CustomRoyaltyFee fromProtobuf(RoyaltyFee royaltyFee) {
        Fraction fraction = royaltyFee.getExchangeValueFraction();
        CustomRoyaltyFee returnFee = new CustomRoyaltyFee().setNumerator(fraction.getNumerator()).setDenominator(fraction.getDenominator());
        if (royaltyFee.hasFallbackFee()) {
            returnFee.fallbackFee = CustomFixedFee.fromProtobuf(royaltyFee.getFallbackFee());
        }
        return returnFee;
    }

    static CustomRoyaltyFee fromProtobuf(com.hedera.hashgraph.sdk.proto.CustomFee customFee) {
        CustomRoyaltyFee returnFee = CustomRoyaltyFee.fromProtobuf(customFee.getRoyaltyFee());
        if (customFee.hasFeeCollectorAccountId()) {
            returnFee.setFeeCollectorAccountId(AccountId.fromProtobuf(customFee.getFeeCollectorAccountId()));
        }
        return returnFee;
    }

    public CustomRoyaltyFee setFeeCollectorAccountId(AccountId feeCollectorAccountId) {
        this.doSetFeeCollectorAccountId(feeCollectorAccountId);
        return this;
    }

    public long getNumerator() {
        return this.numerator;
    }

    public CustomRoyaltyFee setNumerator(long numerator) {
        this.numerator = numerator;
        return this;
    }

    public long getDenominator() {
        return this.denominator;
    }

    public CustomRoyaltyFee setDenominator(long denominator) {
        this.denominator = denominator;
        return this;
    }

    public CustomRoyaltyFee setFallbackFee(CustomFixedFee fallbackFee) {
        Objects.requireNonNull(fallbackFee);
        this.fallbackFee = CustomFixedFee.clonedFrom(fallbackFee);
        return this;
    }

    @Nullable
    public CustomFixedFee getFallbackFee() {
        return this.fallbackFee;
    }

    RoyaltyFee toRoyaltyFeeProtobuf() {
        RoyaltyFee.Builder royaltyFeeBuilder = RoyaltyFee.newBuilder().setExchangeValueFraction(Fraction.newBuilder().setNumerator(this.numerator).setDenominator(this.denominator));
        if (this.fallbackFee != null) {
            royaltyFeeBuilder.setFallbackFee(this.fallbackFee.toFixedFeeProtobuf());
        }
        return (RoyaltyFee)royaltyFeeBuilder.build();
    }

    @Override
    com.hedera.hashgraph.sdk.proto.CustomFee toProtobuf() {
        CustomFee.Builder customFeeBuilder = com.hedera.hashgraph.sdk.proto.CustomFee.newBuilder().setRoyaltyFee(this.toRoyaltyFeeProtobuf());
        return this.finishToProtobuf(customFeeBuilder);
    }
}

